(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    240643,       4865]*)
(*NotebookOutlinePosition[    242030,       4905]*)
(*  CellTagsIndexPosition[    241986,       4901]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Representaciones gr\[AAcute]ficas en el plano", "Title"],

Cell[TextData[StyleBox["Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez\n\
Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author",
  TextAlignment->Left],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell["\<\
Lo que debes aprender en este cuaderno es lo siguiente.
Usar el comando Plot[ ] con algunas de sus opciones m\[AAcute]s usuales para \
representar gr\[AAcute]ficas de curvas planas.
Usar el comando Show[ ] para modificar una gr\[AAcute]fica o representar \
varias gr\[AAcute]ficas a la vez.
Realizar animaciones gr\[AAcute]ficas.
Usar el comando ParametricPlot[ ] con algunas de sus opciones m\[AAcute]s \
usuales para representar curvas planas dadas por sus ecuaciones \
param\[EAcute]tricas.
Usar las primitivas gr\[AAcute]ficas Line[ ], Point[ ], Rectangle[ ], Circle[ \
].\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["El comando Plot[ ]", "Section"],

Cell[TextData[{
  "Uno de los aspectos m\[AAcute]s llamativos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es su capacidad para crear f\[AAcute]cilmente gr\[AAcute]ficos de \
extraordinaria complejidad. Manejando unos pocos comandos podr\[AAcute]s \
hacer sorprendentes representaciones gr\[AAcute]ficas y animaciones en dos y \
en tres dimensiones. El comando que se utiliza para representar la \
gr\[AAcute]fica de una funci\[OAcute]n de una variable es ",
  StyleBox["Plot[funcion,{x,xmin,xmax},opciones]",
    FontWeight->"Bold"],
  ". Puedes representar varias funciones a la vez escribi\[EAcute]ndolas \
todas en una lista ",
  StyleBox["Plot[{funcion1,funcion2,...},{x,xmin,xmax}]",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot[x^2, {x, \(-1\), 1}]\  (*\ 
      usamos\ el\ comando\ sin\ ninguna\ opci\[OAcute]n\ *) \)\)], "Input"],

Cell[TextData[{
  "Como puedes ver, el comando Plot[ ] representa la gr\[AAcute]fica y \
proporciona la salida \"- Graphics - \". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " almacena en esa salida toda la informaci\[OAcute]n de la gr\[AAcute]fica. \
Solamente para satisfacer tu curiosidad vamos a ver lo que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha guardado de la gr\[AAcute]fica anterior."
}], "Text"],

Cell[BoxData[
    \(\(InputForm[%]\  (*\ 
      recuerda\ que\ "\<%\>"\ se\ refiere\ a\ la\ \[UAcute]ltima\ salida\ *) 
      \)\)], "Input"],

Cell[TextData[{
  "Lo que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  ha hecho es evaluar la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  " en una serie de puntos y construir una poligonal \
\"Line[{punto1,punto2,...}]\" formada por los segmentos que unen los \
correspondientes puntos de la gr\[AAcute]fica. Dichos segmentos son tan peque\
\[NTilde]os que lo que se aprecia a simple vista parece una curva suave. Al \
final aparecen una serie de opciones del comando Plot[ ] con sus valores por \
defecto. Es justamente su gran cantidad de opciones lo que proporciona \
versatilidad y potencia al comando Plot[ ]. Aqu\[IAcute] las tienes todas."
}], "Text"],

Cell[BoxData[
    \(Options[Plot]\)], "Input"],

Cell["\<\
Aunque son muchas, en la pr\[AAcute]ctica es suficiente con conocer unas \
pocas. F\[IAcute]jate en que las opciones son reglas de sustituci\[OAcute]n \
de la forma\
\>", "Text"],

Cell[TextData["NombredeOpci\[OAcute]n \[Rule] ValordeOpci\[OAcute]n"], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y todas ellas tienen prefijado un valor por defecto. Si no especificas una \
determinada opci\[OAcute]n, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " supone que quieres utilizar el valor por defecto de la misma. Por \
ejemplo, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " presupone que no quieres enmarcar la gr\[AAcute]fica \
\"Frame\[Rule]False\" (puedes enmarcarla con \"Frame\[Rule]True\") ni poner \
etiquetas a los ejes \"AxesLabel\[Rule]None\" (puedes ponerlas con \
\"AxesLabel\[Rule]{\"etiqueta eje X\",\"etiqueta eje Y\"}\").  Los posibles \
valores de una opci\[OAcute]n debes buscarlos en la ayuda del programa. \
Cuando el valor de una opci\[OAcute]n es \"Automatic\" eso significa que se \
elige por un algoritmo interno. Vamos a ver las opciones del comando Plot[ ] \
que se usan con m\[AAcute]s frecuencia."
}], "Text"],

Cell["PlotRange", "Example"],

Cell[TextData[{
  "Esta opci\[OAcute]n permite controlar el intervalo del eje de ordenadas \
donde se representar\[AAcute] la funci\[OAcute]n. Su valor por defecto es \
\"PlotRange\[Rule]Automatic\" lo que indica que al hacer una representaci\
\[OAcute]n gr\[AAcute]fica, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representar\[AAcute] las partes que considera \"m\[AAcute]s \
interesantes'' de la misma. Si la funci\[OAcute]n crece muy \
r\[AAcute]pidamente ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puede cortar la gr\[AAcute]fica y no representar las partes donde la \
funci\[OAcute]n toma valores muy grandes. "
}], "Text"],

Cell[BoxData[
    \(Plot[Exp[x^3], {x, \(-1.5\), 1.5}]\)], "Input"],

Cell[TextData[{
  "En esta gr\[AAcute]fica ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no ha representado todos los valores de la funci\[OAcute]n."
}], "Text"],

Cell[TextData[{
  "PlotRange\[Rule]All es la forma de decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que muestre el intervalo completo del eje de ordenadas donde toma valores \
la funci\[OAcute]n."
}], "Text"],

Cell[BoxData[
    \(\(\(Plot[Exp[x^3], {x, \(-1.5\), 1.5}, PlotRange -> All]; 
    \)\  (*\ el\ punto\ y\ coma\ al\ final\ es\ para\ que\ no\ aparezca\ la\ 
          salida\  - \ Graphics\  - \ *) \)\)], "Input"],

Cell[TextData[{
  "Ahora est\[AAcute]n representados todos los valores que toma la funci\
\[OAcute]n. Puedes apreciar que en la gr\[AAcute]fica anterior ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " suprimi\[OAcute] una parte \"poco interesante\" de la misma para poder \
mostrar mejor otras partes que consider\[OAcute] de \"mayor \
inter\[EAcute]s\". Observa tambi\[EAcute]n la notable diferencia de escalas \
en los ejes."
}], "Text"],

Cell[TextData[
"Con PlotRange\[Rule]{ymin,ymax} puedes controlar exactamente el rango de \
valores de la funci\[OAcute]n que se representar\[AAcute] en la \
gr\[AAcute]fica."], "Text"],

Cell[BoxData[
    \(\(\(Plot[Exp[x^3], {x, \(-1.5\), 1.5}, PlotRange -> {0, 2.5}]; 
    \) (*\ muestra\ los\ valores\ de\ la\ funci\[OAcute]n\ mayores\ que\ 0\ y
        \ menores\ que\ 2.5\ *) \)\)], "Input"],

Cell[TextData[
"Ahora vas a ver c\[OAcute]mo con PlotRange\[Rule]{{xmin,xmax},{ymin,ymax}} \
puedes mostrar detalles de una gr\[AAcute]fica; algo parecido a \"hacer \
zoom'' sobre ella."], "Text"],

Cell[BoxData[
    \(\(\(Plot[x*Sin[1/x], {x, \(-1\), 1}]; \)\ \)\)], "Input"],

Cell["\<\
La parte m\[AAcute]s interesante de la gr\[AAcute]fica est\[AAcute] en los \
valores pr\[OAcute]ximos a cero.\
\>", "Text"],

Cell[BoxData[
    \(\(\(Plot[x*Sin[1/x], {x, \(-1\), 1}, 
      PlotRange -> {{\(-0.1\), 0.1}, {\(-0.1\), 0.1}}]; \)\ \)\)], "Input"],

Cell["PlotPoints", "Example"],

Cell[TextData[{
  "Esta opci\[OAcute]n permite controlar el n\[UAcute]mero de puntos que usa \
inicialmente el algoritmo interno de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para representar la gr\[AAcute]fica. Su valor por defecto es \"PlotPoints\
\[Rule]25\". Cuando una funci\[OAcute]n oscila mucho puede ser conveniente \
aumentar este n\[UAcute]mero."
}], "Text"],

Cell[BoxData[
    \(\(\(Plot[x*Sin[1/x], {x, \(-1\), 1}, 
      PlotRange -> {{\(-0.1\), 0.1}, {\(-0.1\), 0.1}}, PlotPoints -> 150]; 
    \)\ \)\)], "Input"],

Cell["\<\
Puedes modificar el tama\[NTilde]o de una gr\[AAcute]fica \
seleccion\[AAcute]ndola con el rat\[OAcute]n y arrastrando uno cualquiera de \
los puntos de control.\
\>", "Text"],

Cell["AspectRatio", "Example"],

Cell[TextData[{
  "Esta opci\[OAcute]n permite controlar la escala, es decir la raz\[OAcute]n \
\"altura/anchura\", con la que se representa la gr\[AAcute]fica. Por defecto \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " elige, por razones de apariencia est\[EAcute]ticas, la inversa de la raz\
\[OAcute]n a\[UAcute]rea \"AspectRatio\[Rule]1/GoldenRatio\" ",
  Cell[BoxData[
      \(TraditionalForm\`\((GoldenRatio = \(1 + \@5\)\/2)\)\)]],
  ". Esta opci\[OAcute]n es apropiada la mayor\[IAcute]a de las veces, pero \
no lo es cuando queremos representar ciertas curvas con ejes de simetr\
\[IAcute]a y queremos que se vean como realmente son. En la celda siguiente \
representamos juntas las gr\[AAcute]ficas de las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(1 - x\^2\ \)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\@\(1 - x\^2\)\)\)]],
  " en el intervalo [-1,1] para obtener la circunferencia unidad en el \
plano."
}], "Text"],

Cell[BoxData[
    \(\(Plot[{\@\(1 - x\^2\ \), \(-\@\(1 - x\^2\ \)\)}, {x, \(-1\), 1}]; 
    \)\)], "Input"],

Cell[TextData[{
  "Esto parece una elipse y no una circunferencia. Para que se vea una \
circunferencia basta escribir \"AspectRatio\[Rule]Automatic\" esto hace que ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " determine la raz\[OAcute]nn \"altura/anchura'' ",
  StyleBox[
  "teniendo en cuenta los valores de los puntos de la gr\[AAcute]fica que se \
va a representar",
    FontSlant->"Italic"],
  ". Si dicha gr\[AAcute]fica tiene igual anchura que altura esto hace que se \
ajuste la escala \"altura/anchura'' igual a 1. Con \"AspectRatio\[Rule]1\" le \
pedimos a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que represente un gr\[AAcute]fico con anchura y altura iguales ",
  StyleBox[
  "sin tener en cuenta los valores de los puntos de la gr\[AAcute]fica que se \
va a representar",
    FontSlant->"Italic"],
  " (prueba a representar una elipse con esa opci\[OAcute]n y \
parecer\[AAcute] una circunferencia). En algunos casos es indiferente usar \
\"AspectRatio\[Rule]Automatic\" o \"AspectRatio\[Rule]1\" pero en otros no. \
Como regla, es preferible usar \"AspectRatio\[Rule]Automatic\". "
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["Plot",
          FontFamily->"Courier"], 
        StyleBox["[",
          FontFamily->"Courier"], 
        RowBox[{
          RowBox[{
            StyleBox["{",
              FontFamily->"Courier"], 
            RowBox[{
              RowBox[{
                StyleBox["-",
                  FontFamily->"Courier"], 
                SqrtBox[
                  RowBox[{
                    StyleBox["1",
                      FontFamily->"Courier"], 
                    StyleBox["-",
                      FontFamily->"Courier"], 
                    SuperscriptBox[
                      StyleBox["x",
                        FontFamily->"Courier"], "2"]}]]}], ",", 
              SqrtBox[
                RowBox[{
                  StyleBox["1",
                    FontFamily->"Courier"], 
                  StyleBox["-",
                    FontFamily->"Courier"], 
                  SuperscriptBox[
                    StyleBox["x",
                      FontFamily->"Courier"], "2"]}]]}], "}"}], ",", 
          \({x, \(-1\), 1}\), ",", \(AspectRatio -> Automatic\)}], "]"}], 
      ";"}]], "Input"],

Cell["PlotStyle", "Example"],

Cell["\<\
Esta opci\[OAcute]n permite, entre otras cosas, controlar el color y el \
grosor de las l\[IAcute]neas de una gr\[AAcute]fica. El color puedes \
especificarlo de la siguiente forma.\
\>", "Text"],

Cell[TextData[
"PlotStyle\[Rule]RGBColor[n\[UAcute]mero1,n\[UAcute]mero2,n\[UAcute]mero3]"], 
  "Text",
  TextAlignment->Center],

Cell["\<\
Esto permite escoger un color en funci\[OAcute]n de la cantidad de rojo (n\
\[UAcute]mero1), verde (n\[UAcute]mero2) y azul (n\[UAcute]mero3), donde los \
n\[UAcute]meros pueden tomar cualquier valor entre 0 y 1. Tambi\[EAcute]n \
puedes especificar el color de la forma:\
\>", "Text"],

Cell[TextData["PlotStyle\[Rule]Hue[arg]"], "Text",
  TextAlignment->Center],

Cell["\<\
donde \"arg'' puede tomar cualquier valor num\[EAcute]rico. La \
funci\[OAcute]n \"Hue\" es peri\[OAcute]dica con per\[IAcute]odo 1, \
Hue[x]=Hue[x+1], y asigna a cada valor de su argumento un color desde \
\"Hue[0]\" que es rojo, siguiendo los colores del arco iris, anaranjado, \
amarillo, verde, azul, a\[NTilde]il y violeta, y regresando al rojo \
\"Hue[1]\".\
\>", "Text"],

Cell[TextData[
"El grosor se especifica con \"Thickness[n\[UAcute]mero]\" donde el grosor \
viene expresado como una fracci\[OAcute]n de la anchura total de la gr\
\[AAcute]fica. Por ejemplo, para que las l\[IAcute]neas de la gr\[AAcute]fica \
tengan un grosor del 2% de su anchura escribimos \
\"PlotStyle\[Rule]Thickness[0.02]\". \nPara especificar varios valores de la \
opci\[OAcute]n \"PlotStyle\" debemos escribirlas todas en una lista. Por \
ejemplo, para especificr el color y el grosor de las l\[IAcute]neas \
escribimos \"PlotStyle\[Rule]{Hue[0],Thickness[0.02]}\"."], "Text"],

Cell[BoxData[
    StyleBox[
      \(Plot[Cos[x], {x, 0, 2 Pi}, 
        PlotStyle -> {Thickness[0.01], Hue[ .64]}]; \),
      FontFamily->"Courier"]], "Input"],

Cell["\<\
Si representas varias funciones a la vez puedes dar opciones para cada una de \
ellas escribi\[EAcute]ndolas en una lista.\
\>", "Text"],

Cell[BoxData[
    StyleBox[
      \(Plot[{Cos[x], Sin[x]}, {x, 0, 2 Pi}, 
        PlotStyle -> {Thickness[0.01], Thickness[0.02]}]; \),
      FontFamily->"Courier"]], "Input"],

Cell[BoxData[
    StyleBox[
      \(Plot[{Cos[x], Sin[x]}, {x, 0, 2 Pi}, 
        PlotStyle -> {{Thickness[0.01], Hue[0]}, {Thickness[0.02], 
              Hue[ .14]}}]; \),
      FontFamily->"Courier"]], "Input"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Observaci\[OAcute]n"]], "Subsection"],

Cell[TextData[StyleBox[
"Para hacer la representaci\[OAcute]n gr\[AAcute]fica de una funci\[OAcute]n, \
el comando Plot[ ] llama muchas veces a dicha funci\[OAcute]n. Podemos verlo \
con el siguiente ejemplo."]], "Text"],

Cell[BoxData[{
    \(Clear[f, n]; \nn = 0; 
    f[x_] := \((\(n++\); Sin[x\^3])\)\  (*
      cada\ vez\ que\ se\ ejecute\ esta\ funci\[OAcute]n\ aumentar\[AAcute]\ 
        una\ unidad\ el\ valor\ de\ n . \ Es\ obligado\ usar\ 
        asignaci\[OAcute]n\ diferida*) \), 
    \(Plot[f[x], {x, 0, Pi}]; \[IndentingNewLine]n
    \  (*n\[UAcute]mero\ de\ veces\ que\ el\ comando\ Plot[\ ]\ ha\ llamado\ a
        \ la\ funci\[OAcute]n*) \)}], "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[StyleBox[
"Por eso, cuando la funci\[OAcute]n es complicada, el comando Plot[ ] puede \
consumir mucho tiempo. Algunas veces puede ser conveniente pedirle a Plot[ ] \
que eval\[UAcute]e la funci\[OAcute]n, lo que se hace con \
Plot[Evaluate[f[x]],{x,a,b}]."]], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["El comando Show[ ]", "Section"],

Cell[TextData[{
  "La ejecuci\[OAcute]n de gr\[AAcute]ficas puede ser lenta y m\[AAcute]s si \
son tridimensionales. Para ahorrar tiempo es buena idea asignar nombre a las \
gr\[AAcute]ficas, lo que permite mostrarlos y modificarlos despu\[EAcute]s \
con el comando ",
  StyleBox["Show[graphics,options]",
    FontWeight->"Bold"],
  " ",
  StyleBox["sin necesidad de generarlos de nuevo",
    FontSlant->"Italic"],
  ". Adem\[AAcute]s con el comando Show[ ] puedes representar varias gr\
\[AAcute]ficas superpuestas."
}], "Text"],

Cell[BoxData[
    RowBox[{
      StyleBox[
        \(g1 = Plot[Sin[x] + Sin[2 x], {x, 0, 2 Pi}, 
            PlotStyle -> {Hue[0], Thickness[ .01]}]\),
        FontFamily->"Courier"], 
      StyleBox[";",
        FontFamily->"Courier"], "\n", 
      \(g2 = Plot[Sin[x], {x, 0, 2  Pi}, 
          PlotStyle -> {Hue[0.25], Thickness[ .013]}]\), ";", "\n", 
      \(g3 = Plot[Sin[x] + Sin[4  x], {x, 0, 2  Pi}, 
          PlotStyle -> {Hue[0.64], Thickness[ .017]}]\), ";", "\n", 
      \(Show[g1, g2, g3]\), ";"}]], "Input"],

Cell[TextData[{
  "En casos como el anterior lo que nos interesa es la \[UAcute]ltima gr\
\[AAcute]fica y no la primera. Podemos pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que no muestre una gr\[AAcute]fica en pantalla. Para eso se usa la opci\
\[OAcute]n ",
  StyleBox["DisplayFunction\[Rule]Identity",
    FontWeight->"Bold"],
  " lo que nos obliga despu\[EAcute]s a poner ",
  StyleBox["DisplayFunction\[Rule]$DisplayFunction",
    FontWeight->"Bold"],
  " (que es la opci\[OAcute]n por defecto en los comandos gr\[AAcute]ficos) \
con lo que le decimos a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que muestre la gr\[AAcute]fica en pantalla. Observa la diferencia."
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[
          \(g1 = Plot[Sin[x] + Sin[2 x], {x, 0, 2 Pi}, 
              PlotStyle -> {Hue[0], Thickness[ .01]}, 
              DisplayFunction -> Identity]\),
          FontFamily->"Courier"], 
        StyleBox[";",
          FontFamily->"Courier"], 
        \( (*\ esta\ gr\[AAcute]fica\ no\ se\ representa\ *) \), "\n", 
        \(g2 = Plot[Sin[x], {x, 0, 2  Pi}, 
            PlotStyle -> {Hue[0.25], Thickness[ .013]}, 
            DisplayFunction -> Identity]\), ";", 
        \( (*\ esta\ gr\[AAcute]fica\ no\ se\ representa\ *) \), "\n", 
        \(g3 = Plot[Sin[x] + Sin[4  x], {x, 0, 2  Pi}, 
            PlotStyle -> {Hue[0.64], Thickness[ .017]}, 
            DisplayFunction -> Identity]\), ";", 
        \( (*\ esta\ gr\[AAcute]fica\ no\ se\ representa\ *) \), "\n", 
        \(Show[g1, g2, g3, DisplayFunction -> $DisplayFunction]\), ";"}], 
      " ", \( (*\ pero\ esta\ s\[IAcute]\ *) \)}]], "Input"],

Cell[TextData[{
  " Las opciones de Show[ ] son las mismas opciones de ",
  StyleBox["Graphics[ ]",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \(Options[Graphics]\)], "Input"],

Cell[TextData[{
  "Las opciones que se especifican en el comando Show[ ] prevalecen sobre \
otras posibles opciones anteriores ",
  StyleBox["del mismo tipo",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    StyleBox[
      \(graf1 = 
        Plot[Sin[x], {x, \(-Pi\), Pi}, 
          Ticks -> {{\(-2.5\), \(-1.5\), 1.5, 2.5}, Automatic}];  (*\ 
        especificamos\ las\ marcas\ que\ queremos\ en\ el\ eje\ de\ abscisas\ 
          y\ dejamos\ que\ Mathematica\ las\ represente\ a\ su\ manera\ en\ el
          \ eje\ de\ ordenadas\ *) \nShow[graf1, Ticks -> None]; 
      \  (*\ quitamos\ las\ marcas\ en\ los\ dos\ ejes\ *) \),
      FontFamily->"Courier"]], "Input"],

Cell[TextData[{
  StyleBox["El comando Show[ ] "],
  StyleBox["no",
    FontSlant->"Italic"],
  StyleBox[
  " tiene opciones para controlar el color o el grosor de la l\[IAcute]nea de \
los gr\[AAcute]ficos que previamente has generado. "]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Animaciones gr\[AAcute]ficas", "Section"],

Cell[TextData[{
  StyleBox["Es muy f\[AAcute]cil hacer animaciones gr\[AAcute]ficas con "],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox[
  " para visualizar c\[OAcute]mo evoluciona la gr\[AAcute]fica de una funci\
\[OAcute]n que depende de un par\[AAcute]metro. Por ejemplo, la \
funci\[OAcute]n Sin[x + n] depende del par\[AAcute]metro "],
  StyleBox["n",
    FontWeight->"Bold"],
  StyleBox[
  ". Podemos representar su gr\[AAcute]fica para distintos valores de "],
  StyleBox["n",
    FontWeight->"Bold"],
  StyleBox[
  " y con ello logramos una buena visualizaci\[OAcute]n de su \
evoluci\[OAcute]n (que en este cas\[OAcute] ser\[AAcute] una onda que se \
desplaza).  Para que una animaci\[OAcute]n tenga calidad es necesario que \
todos los gr\[AAcute]ficos individuales tengan el mismo tama\[NTilde]o, lo \
que se logra fijando el mismo intervalo en el eje de abscisas, "],
  StyleBox["{x,a,b}",
    FontWeight->"Bold"],
  StyleBox[
  ", y haciendo que se representen en el mismo intervalo del eje de ordenadas \
"],
  StyleBox["PlotRange\[Rule]{c,d}",
    FontWeight->"Bold"],
  StyleBox[
  ". Podemos tambi\[EAcute]n dar un color a cada gr\[AAcute]fico en funci\
\[OAcute]n del par\[AAcute]metro "],
  StyleBox["n",
    FontWeight->"Bold"],
  StyleBox[
  " lo que puede ser \[UAcute]til para identificar cada uno de ellos. Para \
ver la animaci\[OAcute]n, cuando se hayan representado las gr\[AAcute]ficas \
selecciona una de ellas con el rat\[OAcute]n y haz doble clic. En la esquina \
inferior izquierda de la pantalla aparecen unos botones que permiten \
controlar la velocidad de la animaci\[OAcute]n. \n"],
  StyleBox["Para crear la animaci\[OAcute]n podemos usar tanto la orden "],
  StyleBox["Table[ ]",
    FontWeight->"Bold"],
  StyleBox[" como la orden"],
  StyleBox[" Animate[ ]",
    FontWeight->"Bold"],
  StyleBox[
  ". Ambas aceptan un gr\[AAcute]fico que depende de un par\[AAcute]metro \
junto con indicaciones de c\[OAcute]mo var\[IAcute]a dicho \
par\[AAcute]metro."]
}], "Text"],

Cell[BoxData[
    \(\(\(Animate[\n\t
      Plot[Sin[x + n], {x, 0, 4  Pi}, PlotRange -> {\(-1.1\), 1.1}, 
        PlotStyle -> Hue[n]], \n\t\t\t\t\t{n, 0, 2  Pi, Pi/10}\n\t\t\t\t\t]; 
    \)\n (*\ observa\ la\ forma\ de\ escribir\ el\ c\[OAcute]digo\ para\ que\ 
        se\ lea\ mejor\ *) \)\)], "Input"],

Cell[TextData[StyleBox[
"Tambi\[EAcute]n podemos usar el comando Table[ ] de la misma forma:"]], 
  "Text"],

Cell[BoxData[
    \(\(Table[Plot[Sin[n*x], {x, 0, 4  Pi}, PlotRange -> {\(-1.1\), 1.1}], \n
      \t\t\t\t\t{n, 0, 2  Pi, Pi/10}\n\t\t\t\t\t]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["En versiones m\[AAcute]s modernas de "],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox[
  " es necesario cargar el paquete \"Animation\" para poder utilizar la orden \
Animate."]
}], "Text"],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["El comando ParametricPlot[ ]", "Section"],

Cell[TextData[{
  "Una curva en el plano puede definirse por medio de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`x(t), \ y(t)\)]],
  " son funciones continuas definidas en un intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  ". La curva as\[IAcute] definida tiene como imagen el conjunto ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalGamma] = {\(\((x(t), y(t)\)}\) : t \[Element] \([a, b]\)}
          \)]],
  ". Se dice que dicha curva est\[AAcute] dada en forma param\[EAcute]trica. \
Esta es la forma m\[AAcute]s general de dar una curva en el plano. Observa \
que la gr\[AAcute]fica de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\)]],
  " es la curva dada por las ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((t, f(t))\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] \([a, b]\)\)]],
  ". Para representar gr\[AAcute]ficamente una curva dada en ecuaciones param\
\[EAcute]tricas se usa el comando"
}], "Text"],

Cell["ParametricPlot[{x[t],y[t]},{t,a,b}]", "Text",
  TextAlignment->Center],

Cell[TextData[StyleBox["Puedes ver las opciones que tiene este comando.",
  FontFamily->"Times New Roman"]], "Text"],

Cell[BoxData[
    \(Options[ParametricPlot]\)], "Input"],

Cell["Aqu\[IAcute] tienes algunos ejemplos.", "Text"],

Cell[BoxData[
    StyleBox[
      \(\(ParametricPlot[{Cos[t], Sin[t]}, {t, 0, 2 Pi}, 
        AspectRatio -> Automatic]; \)\  (*\ una\ circunferencia\ *) \),
      FontFamily->"Courier"]], "Input"],

Cell[BoxData[
    StyleBox[
      \(\(ParametricPlot[{Cos[3 t], Sin[5 t + 3]}, {t, 0, 2 Pi}, 
        PlotStyle -> {Hue[ .65], Thickness[ .006]}]\ ; 
      \) (*\ una\ curva\ de\ Lisajoux\ *) \),
      FontSize->12]], "Input"],

Cell[TextData[StyleBox[
"Para terminar, aqu\[IAcute] tienes algunas curvas planas interesantes. ",
  FontFamily->"Times New Roman"]], "Text"],

Cell[TextData[{
  StyleBox["Astroide",
    FontWeight->"Bold"],
  ". Es la curva trazada por un punto fijo de un c\[IAcute]rculo de radio r \
que rueda sin deslizar dentro de otro c\[IAcute]rculo fijo de radio 4r. Sus \
ecuaciones param\[EAcute]tricas son."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{Cos[t]^3, Sin[t]^3}, {t, 0, 2  Pi}, 
      AspectRatio -> Automatic]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["Cardiode",
    FontWeight->"Bold"],
  ". Es la curva trazada por un punto fijo de un c\[IAcute]rculo de radio r \
que rueda sin deslizar alrededor de otro c\[IAcute]rculo fijo del mismo \
radio. Sus ecuaciones param\[EAcute]tricas son."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[\((1 + Cos[t])\) {Cos[t], Sin[t]}, {t, 0, 2  Pi}, 
      AspectRatio -> Automatic]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["Lemniscata de Bernoulli",
    FontWeight->"Bold"],
  ". Es el lugar geom\[EAcute]trico de los puntos del plano ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  ", cuyo producto de distancias a dos puntos fijos ",
  Cell[BoxData[
      \(TraditionalForm\`F\_1\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ F\_2\)\)]],
  ", llamados focos, verifica la igualdad ",
  Cell[BoxData[
      \(TraditionalForm
      \`\( | P - F\_1 | \  | P - F\_2 | \) = 
        1\/4 | F\_1 - F\_2\( | \^2\)\)]],
  ". En coordenadas cartesianas esta curva viene dada por la ecuaci\[OAcute]n \
",
  Cell[BoxData[
      \(TraditionalForm\`\((x\^2 + y\^2)\)\^2 = x\^2 - y\^2\)]],
  ". Aqu\[IAcute] tienes sus ecuaciones param\[EAcute]tricas."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[
      \(Cos[t]\/\(1 + Sin[t]\^2\)\) {1, Sin[t]}, {t, 0, 2  Pi}, 
      AspectRatio -> Automatic]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["Espiral equiangular",
    FontWeight->"Bold"],
  ". Tambi\[EAcute]n llamada espiral logar\[IAcute]tmica. Es aquella espiral \
en la que el radio vector corta a la curva en un \[AAcute]ngulo constante \
\[Alpha]. Sus ecuaciones param\[EAcute]tricas son."
}], "Text"],

Cell[BoxData[
    \(\[Alpha] = Pi/2 - 0.2; \n
    ParametricPlot[Exp[t*Cot[\[Alpha]]] {Cos[t], Sin[t]}, {t, 0, 4  Pi}, 
      AspectRatio -> Automatic]; \nClear[\[Alpha]]\)], "Input"],

Cell[TextData[{
  StyleBox["Cicloide",
    FontWeight->"Bold"],
  ". Tambi\[EAcute]n conocida como tautocrona o braquistocrona. Es la curva \
que describir\[IAcute]a una chincheta clavada en una rueda que avanza girando \
sin deslizar. Sus ecuaciones param\[EAcute]tricas son."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{t - Sin[t], 1 - Cos[t]}, {t, 0, 2  Pi}, 
      AspectRatio -> Automatic]; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Primitivas gr\[AAcute]ficas", "Section"],

Cell[TextData[{
  StyleBox["Como su nombre indica, "],
  StyleBox[
  "las primitivas gr\[AAcute]ficas son los elementos b\[AAcute]sicos \
(primitivos) que utiliza Mathematica para crear gr\[AAcute]ficos complejos",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". "],
  StyleBox["Para "],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox[" una gr\[AAcute]fica es un comando de la forma "]
}], "Text"],

Cell["Graphics[primitivas gr\[AAcute]ficas,opciones]. ", "Text",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox[
  "Para mostrar la gr\[AAcute]fica en pantalla debes usar la orden Show[ ]",
    FontWeight->"Bold"],
  StyleBox[" como sigue"]
}], "Text"],

Cell[TextData[StyleBox[
"Show[Graphics[primitivas gr\[AAcute]ficas,opciones]]."]], "Text",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[TextData[StyleBox[
"La primitiva gr\[AAcute]fica principal es, Line[ ], cuya sintaxis es"]], 
  "Text",
  FontFamily->"Times New Roman"],

Cell[TextData[StyleBox["Line[{{x1,y1},{x2,y2}...{xn,yn}}]"]], "Text",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[TextData[StyleBox[
"que dibuja una l\[IAcute]nea poligonal que une los puntos \
{x1,y1},{x2,y2}...{xn,yn}. "]], "Text"],

Cell[BoxData[
    \(Show[Graphics[Line[{{0, 0}, {1, 1}, {1.2, 2}, {2.2, 1}, {3, 1.2}}]]]
      \)], "Input"],

Cell[TextData[{
  StyleBox[
  "Adem\[AAcute]s de Line[ ] otras primitivas gr\[AAcute]ficas son Point[ ], \
Rectangle[ ], Circle[ ], Disk[ ], Polygon[ ] y Text[ ]. "],
  StyleBox[
  "La primitiva Polygon[{x1,y1},{x2,y2},..] representa un pol\[IAcute]gono \
relleno cuyos v\[EAcute]rtices son los puntos {x1,y1},{x2,y2}, . . . y cuyos \
lados son los segmentos que unen cada punto con el siguiente y el \
\[UAcute]ltimo con el primero. Por ejemplo, Polygon[{0,0},{1,0},{0,1}] es un \
tri\[AAcute]ngulo. Un caso especial de Polygon[ ] es Rectangle[ ] en la que \
se dan los v\[EAcute]rtices inferior izquierdo y superior derecho. La \
primitiva Circle[{x,y},{rx,ry}], produce una elipse de semiejes rx y ry. ",
    FontFamily->"Times New Roman"],
  StyleBox[
  "La primitiva Disk[ ] se comporta igual pero rellena el correspondiente c\
\[IAcute]rculo o elipse. "],
  StyleBox[
  "Para obtener arcos de circunferencia o sectores de c\[IAcute]rculos o de \
elipses basta incluir al final del correspondiente comando una lista de la \
forma {t1,t2} donde 0\[LessEqual]t1<t2\[LessEqual]2Pi. ",
    FontFamily->"Times New Roman"],
  StyleBox[
  "Si tienes alguna duda sobre la sintaxis de estas primitivas \
gr\[AAcute]ficas debes consultar la ayuda de "],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox[". Aqu\[IAcute] tienes algunos ejemplos."]
}], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(Show[Graphics[Polygon[{{0, 0}, {1, 1}, {0, 1}}]]]; \)\)], "Input"],

Cell[BoxData[
    \(\(Show[Graphics[Rectangle[{0, 0}, {1, 1}]]]; \)\)], "Input"],

Cell[TextData[StyleBox[
"Observa que en estas representaciones no figuran los ejes de coordenadas. \
Ello se debe a las opciones por defecto del comando Graphics[ ] entre las que \
figura Axes\[Rule]False. "]], "Text"],

Cell[BoxData[
    \(\(Show[Graphics[Circle[{0, 1}, 1]], Axes -> True]; \)\)], "Input"],

Cell[TextData[StyleBox[
"Bueno, no sale demasiado redondo. Arregl\[EAcute]moslo:"]], "Text"],

Cell[BoxData[
    \(\(Show[
      Graphics[Circle[{0, 1}, 1], AspectRatio -> Automatic, Axes -> True]]; 
    \)\)], "Input"],

Cell[TextData[StyleBox[
"Si de verdad quer\[IAcute]amos dibujar una elipse, deber\[IAcute]amos \
indicar los dos semiejes (en este caso, 2 y 3) adem\[AAcute]s del centro:"]], 
  "Text"],

Cell[BoxData[
    \(\(Show[
      Graphics[Circle[{0, 0}, {3, 2}], AspectRatio -> Automatic, 
        Axes -> True]]; \)\)], "Input"],

Cell[BoxData[
    \(\(Show[
      Graphics[Circle[{0, 0}, 1, {Pi/2, 3  Pi/2}], AspectRatio -> Automatic, 
        Axes -> True]]; \)\)], "Input"],

Cell[BoxData[
    \(\(Show[
      Graphics[Disk[{0, 0}, {2, 1}, {\(-Pi\)/2, Pi/2}], 
        AspectRatio -> Automatic, Axes -> True]]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"El comando gr\[AAcute]fico ListPlot[ ]. Directivas gr\[AAcute]ficas"]], 
  "Subsection"],

Cell[TextData[{
  StyleBox[
  "Hemos dejado para el final una de las primitivas m\[AAcute]s usuales: los \
puntos. En este caso la orden "],
  StyleBox["ListPlot[lista de puntos, opciones]",
    FontWeight->"Bold"],
  StyleBox[" es m\[AAcute]s c\[OAcute]moda:"]
}], "Text"],

Cell[BoxData[
    StyleBox[
      \(ListPlot[Table[{i, i^2}, {i, 12}], 
        PlotStyle -> {PointSize[ .02], RGBColor[1, 0, 0]}]; \),
      FormatType->StandardForm]], "Input"],

Cell[TextData[{
  StyleBox[
  "Podemos controlar la forma en que se representan las primitivas \
gr\[AAcute]ficas, por ejemplo el color, el tama\[NTilde]o o grosor de l\
\[IAcute]nea, usando especificaciones que se conocen como ",
    FontFamily->"Times New Roman"],
  StyleBox["directivas gr\[AAcute]ficas",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  " las cuales siempre preceden a las primitivas gr\[AAcute]ficas a las \
cuales se aplican. Algunas directivas gr\[AAcute]ficas ususales son \
Thickness[ ], PointSize[ ], RGBColor[ ] o Hue[ ]. ",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[TextData[StyleBox[
"Por ejemplo, las ra\[IAcute]ces quintas de 1 son los puntos (cos(2k\[Pi]/5), \
sen(2k\[Pi]/5)), 0\[LessEqual]k\[LessEqual]4. Para representarlos en rojo y \
de tama\[NTilde]o apropiado usamos las directivas gr\[AAcute]ficas Hue[ ] y \
PointSize[ ] precediendo a la lista de dichos puntos.",
  FontFamily->"Times New Roman"]], "Text"],

Cell[BoxData[
    StyleBox[
      \(\(vertices = {Hue[0]\ , PointSize[ .03]\ , 
          Table[Point[{Cos[2\ k\ Pi/5], Sin[2\ k\ Pi/5]}], {k, 0, 4}]}; \)\ 
      \),
      FormatType->StandardForm]], "Input"],

Cell[TextData[StyleBox[
"Podemos unir dichos v\[EAcute]rtices por segmentos usando la primitiva gr\
\[AAcute]fica Line[ ] y podemos representar dichos segmentos en color azul y \
grosor apropiado usando las directivas Hue[ ] y Thickness[ ] precediendo a \
Line[ ].",
  FontFamily->"Times New Roman"]], "Text"],

Cell[BoxData[
    StyleBox[
      \(\(lados = {Hue[ .65] (*\ especificamos\ color\ *) , 
          Thickness[ .02] (*\ especificamos\ grosor\ de\ l\[IAcute]nea\ *) , 
          Line[Table[\n{Cos[2\ k\ Pi/5], Sin[2\ k\ Pi/5]}, {k, 0, 5}]]}; 
      \)\  (*\ usamos\ Line[]\ para\ generar\ una\ l\[IAcute]nea\ poligonal\ 
          que\ une\ los\ v\[EAcute]rtices\ *) \),
      FormatType->StandardForm]], "Input"],

Cell[TextData[StyleBox["Obtenemos un pent\[AAcute]gono."]], "Text"],

Cell[BoxData[
    StyleBox[
      \(pentagono = 
        Show[Graphics[{lados, vertices}], AspectRatio -> Automatic]; \),
      FormatType->StandardForm]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Las opciones Prolog y Epilog", "Section"],

Cell["\<\
Las opciones Prolog\[Rule]{primitivas gr\[AAcute]ficas} y \
Epilog\[Rule]{primitivas gr\[AAcute]ficas} sirven para a\[NTilde]adir a una \
representaci\[OAcute]n gr\[AAcute]fica dada por un comando como Plot[ ] o \
ParametricPlot[ ] elementos gr\[AAcute]ficos especificados por las \
correspondientes primitivas gr\[AAcute]ficas. La diferencia entre ellos es \
que Prolog a\[NTilde]ade los elementos gr\[AAcute]ficos antes de que se \
represente la parte principal de la gr\[AAcute]fica y Epilog los \
a\[NTilde]ade despu\[EAcute]s. Los siguientes ejemplos ponen de manifiesto \
este comportamiento.\
\>", "Text"],

Cell[BoxData[
    \(\(\(Plot[Sin[x], {x, \(-Pi\), Pi}, 
        PlotStyle \[Rule] {Hue[ .64], Thickness[ .02]}, 
        Epilog \[Rule] {PointSize[0.05], 
            Hue[0], {Point[{\[Pi]/7, Sin[\[Pi]/7]}], 
              Point[{\[Pi]/5, Sin[\[Pi]/5]}], 
              Point[{\[Pi]/3, Sin[\[Pi]/3]}]}}];\)\( (*\ 
      sobre\ la\ gr\[AAcute]fica\ de\ la\ funci\[OAcute]n\ Sin[
          x]\ hemos\ representado\ tres\ puntos\ en\ rojo . \ 
          La\ gr\[AAcute]fica\ se\ representa\ primero\ y\ los\ puntos\ despu\
\[EAcute]s\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(Plot[Sin[x], {x, \(-Pi\), Pi}, 
        PlotStyle \[Rule] {Hue[ .64], Thickness[ .02]}, 
        Prolog \[Rule] {PointSize[0.05], 
            Hue[0], {Point[{\[Pi]/7, Sin[\[Pi]/7]}], 
              Point[{\[Pi]/5, Sin[\[Pi]/5]}], 
              Point[{\[Pi]/3, Sin[\[Pi]/3]}]}}];\)\( (*\ 
      sobre\ la\ gr\[AAcute]fica\ de\ la\ funci\[OAcute]n\ Sin[
          x]\ hemos\ representado\ tres\ puntos\ en\ rojo . \ 
          Ahora\ los\ puntos\ se\ representan\ primero\ y\ la\ \
gr\[AAcute]fica\ despu\[EAcute]s\ *) \)\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo", "Section"],

Cell[TextData[{
  "Lo que hemos visto en el cuaderno anterior para generar listas y evaluar \
funciones en listas lo puedes usar para hacer representaciones \
gr\[AAcute]ficas. ",
  StyleBox["Para ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  " los comandos gr\[AAcute]ficos son funciones y puedes trabajar con ellos \
igual que se trabaja con funciones",
    FontWeight->"Bold"],
  ". Por ejemplo, c",
  StyleBox["onsidera la siguiente lista de puntos.",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[BoxData[
    \(\(puntos = Table[{x, Sin[x]}, {x, \(-3\) Pi, 3  Pi,  .3}]; \)\)], 
  "Input"],

Cell[TextData[{
  "Supongamos que queremos representar ",
  StyleBox[
  "dichos puntos en rojo y con tama\[NTilde]o apropiado as\[IAcute] como los \
segmentos verticales en verde que unen cada uno de ellos con el eje de \
abscisas y la poligonal en azul que une cada punto con el siguiente en la \
lista. Est\[AAcute] claro que vamos a necesitar usar las primitivas gr\
\[AAcute]ficas Point[ ] y Line[ ]. Si tuvi\[EAcute]ramos que escribir una \
primitiva Point[ ] por cada punto de la lista anterior ser\[IAcute]a muy \
largo porque hay muchos puntos. Una forma r\[AAcute]pida de hacerlo es \
evaluar la funci\[OAcute]n Point[ ] en dicha lista y eso ya sabes hacerlo.",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[BoxData[
    \(\(nuevospuntos = Map[Point, puntos] (*no\ pongo\ ; \ 
      para\ que\ veas\ la\ lista\ generada*) \)\)], "Input"],

Cell["\<\
Nos hemos ahorrado un buen trabajo. Lo siguiente es generar los segmentos \
verticales que unen cada punto {x,y} de la lista inicial con {x,0}. Observa \
que lo que queremos es convertir {x,y} en {{x,y},{x,0}} porque sobre este \
\[UAcute]ltimo par de puntos podemos hacer actuar la funci\[OAcute]n \
Line[{punto1,punto2}] que nos va a proporcionar el segmento vertical deseado. \
Esto puede hacerse de muchas formas, bien con una regla de \
sustituci\[OAcute]n o con una funci\[OAcute]n apropiada. Vamos a hacerlo de \
las dos formas.\
\>", "Text"],

Cell[BoxData[
    \(segmentos = puntos /. {x_?NumberQ, y_?NumberQ} -> {{x, y}, {x, 0}}\)], 
  "Input"],

Cell[BoxData[
    \(funcion[{x_, y_}] = {{x, y}, {x, 0}}; \n
    segmentos = Map[funcion, puntos]\)], "Input"],

Cell["Ahora aplicamos Line[ ].", "Text"],

Cell[BoxData[
    \(segmentos = Map[Line, segmentos]\)], "Input"],

Cell["\<\
Solamente falta la poligonal que une los puntos de la lista inicial. Eso es \
facil.\
\>", "Text"],

Cell[BoxData[
    \(poligonal = Line[puntos]\)], "Input"],

Cell["\<\
Ahora represntamos todas las primitivas gr\[AAcute]ficas con Show[Graphics[ \
]] y damos en cada caso las directivas gr\[AAcute]ficas de color y grosor \
apropiadas.\
\>", "Text"],

Cell[BoxData[
    \(\(Show[
      Graphics[{{Hue[0], PointSize[ .02], nuevospuntos}, {Hue[ .6], 
            poligonal}, {Hue[ .25], Thickness[ .007], segmentos}}], 
      Axes -> True]; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "ExerciseMain"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 1"]], "Exercise"],

Cell[TextData[StyleBox[
"Representa con el comando Plot[ ] juntas en una misma gr\[AAcute]fica las \
funciones seno y coseno en el intervalo [-2\[Pi],2\[Pi]]. Utiliza las  \
opciones apropiadas para que una de las funciones se represente en azul y \
otra en rojo. Una tenga un grosor mayor que la otra. Utiliza la \
opci\[OAcute]n \"PlotLabel\" para rotular la gr\[AAcute]fica con \"funciones \
seno y coseno\". Pon color amarillo de fondo usando \"Background\"."]], 
  "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 2"]], "Exercise"],

Cell[TextData[StyleBox[
"Compara las gr\[AAcute]ficas de las funciones cos(x) y cos(-x). \
\[DownQuestion]A qu\[EAcute] conclusi\[OAcute]n llegas sobre la paridad o \
imparidad de la funci\[OAcute]n coseno? Haz lo mismo para las funciones \
sen(x) y sen(-x)."]], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 3"]], "Exercise"],

Cell[TextData[{
  StyleBox[
  "Representa las funciones logaritmo neperiano, exponencial y f(x)="],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`x\^2\)]]],
  StyleBox[" "],
  StyleBox[
  "con colores diferentes. Compara el crecimiento de estas funciones cerca de \
cero y lejos de cero. \[DownQuestion]Qu\[EAcute] ocurre si la base de la \
exponencial y del logaritmo es menor que 1? "]
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 4"]], "Exercise"],

Cell[TextData[StyleBox[
"\tDibuja las gr\[AAcute]ficas de las funciones coseno hiperb\[OAcute]lico, \
seno hiperb\[OAcute]lico, argumento seno hiperb\[OAcute]lico y argumento \
coseno hiperb\[OAcute]lico. \[DownQuestion]Alguna de ellas es par o impar? \
\[DownQuestion]Son positivas?"]], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 5"]], "Exercise"],

Cell[TextData[StyleBox[
"\tEncuentra las funciones cuyas gr\[AAcute]ficas corresponden a las \
siguientes curvas.\n"]], "Text"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 0.309017 0.294302 [
[.11905 .29652 -6 -9 ]
[.11905 .29652 6 0 ]
[.30952 .29652 -6 -9 ]
[.30952 .29652 6 0 ]
[.69048 .29652 -3 -9 ]
[.69048 .29652 3 0 ]
[.88095 .29652 -3 -9 ]
[.88095 .29652 3 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .30902 m
.11905 .31527 L
s
[(-4)] .11905 .29652 0 1 Mshowa
.30952 .30902 m
.30952 .31527 L
s
[(-2)] .30952 .29652 0 1 Mshowa
.69048 .30902 m
.69048 .31527 L
s
[(2)] .69048 .29652 0 1 Mshowa
.88095 .30902 m
.88095 .31527 L
s
[(4)] .88095 .29652 0 1 Mshowa
.125 Mabswid
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.07143 .30902 m
.07143 .31277 L
s
.02381 .30902 m
.02381 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.97619 .30902 m
.97619 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04414 m
.50375 .04414 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.03279 .22314 L
.04262 .13792 L
.04758 .1012 L
.05288 .06809 L
.05789 .04358 L
.06006 .03518 L
.06244 .02754 L
.06507 .02117 L
.0665 .01859 L
.06719 .01759 L
.06785 .01677 L
.0691 .01558 L
.07025 .01494 L
.07148 .01472 L
.07218 .01481 L
.07283 .01503 L
.07354 .01543 L
.0743 .01604 L
.07503 .01679 L
.07569 .01762 L
.07829 .02222 L
.07964 .02543 L
.08112 .02961 L
.0841 .04007 L
.08922 .06393 L
.09469 .09721 L
.10458 .17383 L
.12439 .36062 L
.13484 .45549 L
.14057 .50081 L
.14594 .53718 L
.15107 .56524 L
.15578 .58454 L
.15832 .59225 L
.161 .5982 L
.1624 .60041 L
.16369 .60191 L
.16444 .60253 L
.16512 .60293 L
.1659 .60322 L
.16664 .60332 L
.16774 .60313 L
.16896 .60248 L
.17023 .60129 L
.17142 .59971 L
.17354 .59578 L
.17583 .58999 L
.1785 .5812 L
.18103 .5709 L
Mistroke
.18579 .5467 L
.1954 .48074 L
.20563 .3919 L
.22403 .21603 L
.23434 .1282 L
.23976 .08978 L
.24548 .05685 L
.2505 .03529 L
.25335 .02636 L
.25471 .02296 L
.256 .02028 L
.25717 .01829 L
.25844 .01663 L
.2596 .01556 L
.26067 .01496 L
.26182 .01472 L
.26309 .01494 L
.26373 .01525 L
.26442 .01573 L
.26567 .01698 L
.26693 .01874 L
.26807 .02078 L
.27064 .02685 L
.27302 .03427 L
.27526 .04282 L
.2803 .06723 L
.28575 .10113 L
.30686 .28317 L
.32638 .46437 L
.33173 .50583 L
.33747 .54349 L
.34289 .57137 L
.34523 .5809 L
.34783 .58954 L
.35027 .59579 L
.35161 .59843 L
.35286 .60039 L
.35403 .60177 L
.35511 .60266 L
.35628 .6032 L
.35753 .6033 L
.35879 .60289 L
.35949 .60244 L
.36014 .60189 L
.36138 .60044 L
.36256 .59862 L
.36521 .59296 L
.36808 .58437 L
.37293 .5643 L
.37807 .53594 L
Mistroke
.38728 .46945 L
.40706 .28676 L
.42514 .12576 L
.4299 .09198 L
.4351 .06125 L
.43748 .04958 L
.44001 .03889 L
.44238 .03058 L
.44456 .02445 L
.44586 .02151 L
.44727 .01888 L
.4487 .01688 L
.44948 .01606 L
.45021 .01547 L
.45089 .01507 L
.45155 .01483 L
.45277 .01474 L
.45409 .01518 L
.45483 .01567 L
.45552 .01629 L
.4567 .0177 L
.45781 .01942 L
.46033 .02478 L
.46279 .03191 L
.46545 .04163 L
.47041 .06525 L
.47503 .09308 L
.4855 .17357 L
.50661 .37265 L
.51714 .46669 L
.52231 .50659 L
.52708 .53831 L
.53133 .56184 L
.536 .58198 L
.53843 .5899 L
.5407 .59569 L
.54193 .59815 L
.5431 .60005 L
.54374 .60091 L
.54444 .60171 L
.54567 .60271 L
.54632 .60305 L
.54701 .60326 L
.54824 .60326 L
.54956 .60272 L
.55031 .60216 L
.55101 .60148 L
.55228 .59985 L
.55343 .59792 L
.55603 .59207 L
Mistroke
.55834 .58512 L
.56084 .57576 L
.5654 .55414 L
.57631 .48106 L
.58639 .39371 L
.6067 .2004 L
.61663 .11813 L
.62573 .06046 L
.63019 .04003 L
.63272 .03102 L
.63507 .02438 L
.63623 .02173 L
.63732 .01961 L
.63831 .01801 L
.63936 .01667 L
.64051 .0156 L
.64156 .01498 L
.6427 .01472 L
.64395 .0149 L
.64526 .01564 L
.6465 .01684 L
.64762 .01834 L
.64884 .02042 L
.65156 .02677 L
.65408 .03467 L
.65867 .05387 L
.66355 .08066 L
.67291 .1479 L
.68301 .23729 L
.70129 .41177 L
.71166 .49837 L
.71672 .53316 L
.72132 .5594 L
.72619 .58091 L
.72887 .58979 L
.73139 .59616 L
.73273 .59872 L
.73414 .60082 L
.73535 .60212 L
.73604 .60264 L
.73668 .603 L
.73742 .60325 L
.73813 .60332 L
.73945 .60303 L
.74018 .60262 L
.74087 .60209 L
.74162 .60134 L
.74242 .60033 L
.74366 .59837 L
.74503 .59565 L
Mistroke
.74779 .58841 L
.75034 .57964 L
.75272 .56972 L
.7581 .54153 L
.76386 .50328 L
.78404 .32528 L
.80388 .14304 L
.80931 .10236 L
.81508 .06645 L
.82001 .04269 L
.82281 .03227 L
.82544 .02464 L
.82777 .01965 L
.8291 .01759 L
.83032 .01616 L
.83163 .01518 L
.83281 .01476 L
.83347 .01472 L
.83418 .01483 L
.83546 .01544 L
.83657 .01639 L
.83779 .01788 L
.83905 .01994 L
.84024 .02232 L
.84236 .02768 L
.84464 .03496 L
.85019 .05906 L
.85546 .08966 L
.86532 .16393 L
.88351 .33383 L
.89387 .43068 L
.90361 .50906 L
.90823 .53953 L
.9131 .56584 L
.91565 .577 L
.91845 .58706 L
.92099 .59415 L
.92335 .59897 L
.92466 .60087 L
.9254 .60171 L
.92608 .60233 L
.92734 .60307 L
.92797 .60326 L
.92866 .60332 L
.92987 .60305 L
.93116 .60225 L
.93238 .601 L
.9335 .59944 L
.93488 .59698 L
.93616 .59416 L
Mistroke
.93906 .58588 L
.94162 .57648 L
.94435 .56436 L
.95223 .51819 L
.96075 .45256 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oe`3oool0
0`000000oooo0?ooo`3F0?ooo`00e`3oool00`000000oooo0?ooo`3F0?ooo`00e`3oool00`000000
oooo0?ooo`3F0?ooo`00bP3oool00`3oe9/000000000000300000003002Ke03oool0oooo00@0oooo
00<000000?ooo`3oool0eP3oool00<d0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?oo
o`3F0?ooo`00c@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo0=H0oooo000O0?oo
o`800000C`3oool200000500oooo0P0000090?ooo`030;YbLP2jj_l0oooo00L0oooo1000000i0?oo
o`800000D03oool00`000000oooo0?ooo`170?ooo`007P3oool010000000oooo00000000001=0?oo
o`80000000<0oooo000000000000C@3oool600000003001b^P3oool0oooo00<0oooo00<0^W9b0;[Z
o`3oool01`3oool00`000000oooo0?ooo`0i0?ooo`040000003oool00000000004h0oooo00<00000
0?ooo`000000B03oool001d0oooo00D000000?ooo`3oool0oooo0000001=0?ooo`050000003oool0
oooo0?ooo`000000C03oool010000000oooo0?ooo`3oool2000000L0oooo00<0^W9b0;[Zo`3oool0
1`3oool00`000000oooo0?ooo`0h0?ooo`050000003oool0oooo0?ooo`000000C@3oool01@000000
oooo0?ooo`3oool0000004L0oooo000M0?ooo`050000003oool0oooo0?ooo`000000C03oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`050?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0=`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo04X0oooo00D000000?ooo`3oool0oooo00000017
0?ooo`00703oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo04T0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo00@0oooo00T000000?oo
o`3oool0oooo0>ZjLP00000007:j0;YbLP2jj_l0203oool00`000000oooo0?ooo`0g0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo04@0oooo000L0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0A`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`030?ooo`030>ZjLP000780^^[o00P0oooo00<000000?ooo`3oool0=`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`140?ooo`006`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo04L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`160?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo04<0oooo000K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0AP3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`170?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0@`3oool001X0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo04D0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`120?ooo`006P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`140?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0e0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0A@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0480oooo000J0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0A@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo04@0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03D0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0@P3oool001T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`12
0?ooo`006@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo04<0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0@`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0440oooo000I0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo0480oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`<0
0000=@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`110?ooo`006@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo0480oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`120?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0d0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo0440oooo000I0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0@P3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`120?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0@@3o
ool001P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`110?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0440oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`110?ooo`00603oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`110?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0d0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0@@3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo0400oooo000H0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0400
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03<0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0@03oool001P0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`100?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0@03oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`100?ooo`00603oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0400oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0@@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0400oooo000G
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0o
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0@03oool001L0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool0?`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool0<`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo03l0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`100?ooo`005`3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo03l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0o0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0c0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo03l0oooo000G0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
?`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
?`3oool001L0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0n0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo03l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0o0?ooo`005`3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0n0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02@3oool3
00000380oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0?`3oool001H0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0m0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0?@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0<P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0o0?ooo`005P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03d0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03l0
oooo000F0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0?@3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0m0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0?`3oool001H0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool0?@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0<@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03d0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0n0?ooo`005P3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0l
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0a
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo03h0oooo000F0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool0?03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03`0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0340oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool0?P3oool001H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0k0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo03`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0n0?ooo`00
5@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
?03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03h0oooo000E0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo03/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo0340oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0k0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0?P3oool001D0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0k0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0<03oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0n0?ooo`005@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
03d0oooo000E0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`070?ooo`<00000<03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03/0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0m0?ooo`005@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0`0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>`3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo03d0oooo000E0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool0>P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0300oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool0?@3oool001@0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0i
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0m
0?ooo`00503oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03T0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool0>@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03d0oooo000D0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo03T0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo02l0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0i0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0?03oool001@0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
>@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
;`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0l0?ooo`00503oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo03P0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0h0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0_0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo03`0oooo000D0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0>03oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0i0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0?03oool0
01@0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0l0?ooo`00503oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`0h0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0_0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0=`3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo03`0oooo000C0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03P0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02l0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool0>`3oool001<0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`0g0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?oo
o`0D0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`0k0?ooo`004`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03L0oooo00<00000
0?ooo`3oool05@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool01P3oool3000002h0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0g
0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0>`3oool001<0oooo00<000000?oo
o`3oool05@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`3oool0=`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0;P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03L0oooo00<000000?oo
o`3oool05@3oool00`000000oooo0?ooo`0k0?ooo`004`3oool00`000000oooo0?ooo`0E0?ooo`03
0000003oool0oooo03L0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0^0?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo03/0oooo000C0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
=P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0
>`3oool001<0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0f0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo03D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0j0?ooo`004`3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05P3oool0
0`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0^0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0=@3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03X0oooo000C0?ooo`030000003oool0oooo
01H0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo
03H0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
02h0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool0>P3oool00180oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0e0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0=P3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0;P3oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0j0?ooo`004P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03D0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03X0oooo
000B0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo03D0oooo00@000000?ooo`3oool0omBK0`0000000`2Ke?l0oooo
0?ooo`030?ooo`030=BK0000000009_D00D0oooo00H0e9/0000000000000000009_Do`0000060?oo
o`030000003oool0oooo02d0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0d0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool0>P3oool00180oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0=03oool02P000000oooo0?ooo`3oool0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK
0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000000000H0oooo00<000000?oo
o`3oool0;@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03@0oooo00<000000?oo
o`3oool06@3oool00`000000oooo0?ooo`0i0?ooo`004P3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo03D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0d0?ooo`05
0000003oool0oooo0?oDV`00Vm@00`3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`000000oooo
00D0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
03<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0i0?ooo`004P3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0d0?ooo`050000003oool0oooo0>ZjLP1b^^X00`3oool00`3oe9/009_D0?ooo`0?0?oo
o`030?oDV`000000oooo00D0oooo1000000/0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool0<`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03T0oooo000B0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo02h0oooo00<0^W80000000000000100000020?ooo`030>ZjLP1b^^X0oooo0080
oooo00<0omBK002Ke03oool03`3oool00`2jLP0000000?ooo`050?ooo`030000003oool0oooo02d0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0>@3oool00180oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0c0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=03oool01@000000oooo
0?ooo`3Z^W80L[[Z00<0oooo00<0omBK002Ke03oool02P3oool00`3oom@0V`000000000200000003
07:jjP3oool0000000D0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo03<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0i0?ooo`00
4P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0d0?ooo`050000003oool0oooo0?oDV`1b^^X00`3oool00`3Z^W80
L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo00@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0<`3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo03T0oooo000A0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03@0oooo
00X000000?ooo`3oool0oooo0;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Co
o`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0i0?ooo`004@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03<0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0c0?ooo`090000003oool0oooo0?ooo`3oom@0V`00
000000000780^^[o00`0oooo00<0oooD09/0000000000P0000000`0009/0e?oo000000050?ooo`03
0000003oool0oooo02`0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0c0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool0>@3oool00140oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
<`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
;03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0i0?ooo`004@3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo03<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0b0?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0/0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo03P0oooo000A0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0<`3oool0
0`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool06P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0>03oool0
0140oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0h0?ooo`004@3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool06P3oool00`000000
oooo0?ooo`0b0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0/0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`0K0?ooo`030000003oool0oooo03P0oooo000A0?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0380oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02`0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01/0oooo
00<000000?ooo`3oool0>03oool00140oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`0a0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?oo
o`0K0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0;03oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool06`3oool00`000000oooo0?oo
o`0h0?ooo`004@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0340oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01/0oooo00<00000
0?ooo`3oool00P3oool3000002/0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0a
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0>03oool00100oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01/0oooo00<000000?oo
o`3oool0<@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0340oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`0h0?ooo`00403oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0340oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0a0?ooo`03
0000003oool0oooo01/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0[0?ooo`03
0000003oool0oooo01/0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo03P0oooo000@0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0
<@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0
703oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0
>03oool00100oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0a0?ooo`030000003o
ool0oooo01/0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0L0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo0300oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0g0?ooo`00403oool0
0`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool06`3oool0
0`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0[0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0<03oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo03L0oooo000@0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo
0300oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
02/0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool0=`3oool00100oooo00<000000?ooo`3oool0703oool00`000000
oooo0?ooo`0_0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0<03oool00`000000
oooo0?ooo`0M0?ooo`050000003oool0oooo0?ooo`000000;@3oool00`000000oooo0?ooo`0L0?oo
o`030000003oool0oooo02l0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0g0?oo
o`00403oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3o
ool0703oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01d0oooo00D000000?ooo`3o
ool0oooo0000000]0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0;`3oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo03L0oooo000@0?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02l0
oooo00<000000?ooo`3oool07@3oool01@000000oooo0?ooo`3oool0000002`0oooo00<000000?oo
o`3oool07@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01d0oooo00<000000?oo
o`3oool0=`3oool000l0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0_0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0M0?ooo`05
0000003oool0oooo0?ooo`000000;03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo
02l0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0g0?ooo`003`3oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0^0?ooo`030000003oool0oooo01h0oooo00D000000?ooo`3oool0oooo0000000/0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo03L0oooo000?0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool0;`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3o
ool07P3oool01@000000oooo0?ooo`3oool0000002`0oooo00<000000?ooo`3oool07@3oool00`00
0000oooo0?ooo`0_0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0=`3oool000l0
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0N0?ooo`040000003oool0oooo0?oo
o`<00000:P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02l0oooo00<000000?oo
o`3oool07@3oool00`000000oooo0?ooo`0g0?ooo`003`3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo02l0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0^0?ooo`03
0000003oool0oooo01h0oooo00D000000?ooo`3oool0oooo0000000/0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
03L0oooo000?0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0;`3oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool07P3oool01@000000
oooo0?ooo`3oool0000002`0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0^0?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool0=P3oool000l0oooo00<000000?ooo`3o
ool07P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3o
ool0;P3oool00`000000oooo0?ooo`0O0?ooo`040000003oool0oooo000002`0oooo00<000000?oo
o`3oool07P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01l0oooo00<000000?oo
o`3oool0=P3oool000l0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0]0?ooo`03
0000003oool0oooo01h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0O0?ooo`04
0000003oool0oooo000002`0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool0=P3oool000l0oooo00<000000?ooo`3o
ool07P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool0;@3oool00`000000oooo0?ooo`0O0?ooo`040000003oool0oooo000002/0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01l0oooo00<000000?oo
o`3oool0=P3oool000h0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0]0?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0O0?ooo`04
0000003oool0oooo000002/0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool0=P3oool000h0oooo00<000000?ooo`3o
ool07`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool0;03oool00`000000oooo0?ooo`0P0?ooo`040000003oool0oooo000002/0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01l0oooo00<000000?oo
o`3oool0=P3oool000h0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0]0?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0P0?ooo`04
0000003oool0oooo000002/0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool0=P3oool000h0oooo00<000000?ooo`3o
ool07`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool0;03oool00`000000oooo0?ooo`0P0?ooo`040000003oool0oooo000002/0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01l0oooo00<000000?oo
o`3oool0=P3oool000h0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0]0?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0P0?ooo`04
0000003oool0oooo000002/0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool0=P3oool000h0oooo00<000000?ooo`3o
ool07`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool0;03oool00`000000oooo0?ooo`0P0?ooo`040000003oool0oooo000002/0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0200oooo00<000000?oo
o`3oool0=P3oool000h0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0/0?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo00<00000:@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02/0
oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0e0?ooo`003P3oool00`000000oooo
0?ooo`0P0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0803oool00`000000oooo
0?ooo`0/0?ooo`030000003oool0oooo0240oooo00<000000?ooo`000000:`3oool00`000000oooo
0?ooo`0P0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool08@3oool00`000000oooo
0?ooo`0e0?ooo`003P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02/0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo0240oooo00<0
00000?ooo`000000:`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02/0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`0e0?ooo`003@3oool00`000000oooo0?ooo`0Q
0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0[
0?ooo`030000003oool0oooo0240oooo00<000000?ooo`000000:P3oool00`000000oooo0?ooo`0Q
0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0e
0?ooo`003@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02/0oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`000000:P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02/0oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`0e0?ooo`003@3oool00`000000oooo0?ooo`0Q0?ooo`03
0000003oool0oooo02/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0Z0?ooo`03
0000003oool0oooo0280oooo00<000000?ooo`000000:P3oool00`000000oooo0?ooo`0Q0?ooo`03
0000003oool0oooo02/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0e0?ooo`00
3@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0
8@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0280oooo00<000000?ooo`000000
:P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0
8@3oool00`000000oooo0?ooo`0e0?ooo`003@3oool00`000000oooo0?ooo`0Q0?ooo`030000003o
ool0oooo02/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0Z0?ooo`030000003o
ool0oooo0280oooo00<000000?ooo`000000:P3oool00`000000oooo0?ooo`0Q0?ooo`030000003o
ool0oooo02/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0e0?ooo`003@3oool0
0`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00<0oooo00D0onZj078000000000000009_D
o`0S0?ooo`030000003oool0oooo0240oooo00@000000?ooo`3oom@0V`001@0000000`2Ke?l0oooo
0?ooo`0Q0?ooo`030000003oool0oooo0280oooo00<000000?ooo`000000:P3oool00`000000oooo
0?ooo`0O0?ooo`030?ooe02K0000000000@0000000<0VmCo0?ooo`3oool09P3oool00`000000oooo
0?ooo`0Q0?ooo`030000003oj[X0LP000080000000<0VmCo0?ooo`3oool0<03oool000d0oooo00<0
00000?ooo`3oool08P3oool00`000000oooo0?ooo`040?ooo`030=BK002Ke?l0oooo02<0oooo00<0
00000?ooo`3oool08@3oool01P000000oooo0?ooo`3DV`00002K0=Coo`80oooo00<0j[ZK0;[Zo`3o
ool08P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0000002X0oooo00<000000?ooo`3o
ool0803oool00`3DV`0000000=Coo`020?ooo`030>ZjV`2jj_l0oooo02H0oooo00<000000?ooo`3o
ool08P3oool01@000000oooo0?ooo`3DV`00VmCo03<0oooo000=0?ooo`030000003oool0oooo0280
oooo00<000000?ooo`3oool0103oool00`3DV`00VmCo0?ooo`0R0?ooo`030000003oool0oooo02<0
oooo00H000000?ooo`3oool0omBK0000LP2jj_lV0?ooo`030000003oool0oooo0280oooo00<00000
0?ooo`000000:P3oool00`000000oooo0?ooo`0Q0?ooo`030?oDV`000000^^[o02X0oooo00<00000
0?ooo`3oool08`3oool010000000oooo0=BK002Ke?lc0?ooo`003@3oool00`000000oooo0?ooo`0R
0?ooo`040000003oool0oooo0>ZjLPD0000000<0VmCo0?ooo`3oool0803oool00`000000oooo0?oo
o`0S0?ooo`070000003oool0oooo0?ooo`3oj[X0LP0007:jjP0U0?ooo`030000003oool0oooo02<0
oooo0P00000Z0?ooo`030000003oool0oooo0280oooo00<000000780001b^^X0:@3oool00`000000
oooo0?ooo`0Q0?ooo`030>ZjLP000000000000<0000000<0VmCo0?ooo`3oool0<03oool000d0oooo
00<000000?ooo`3oool0703oool00`2jLP0000000000000400000080oooo00H0omBK0000V`3Dool0
oooo0=BK002Ke?lS0?ooo`030000003oool0oooo01`0oooo00<0^W800000000000000`0000000`00
L[X000000?ooo`040?ooo`030;Yb001b^^X0oooo0280oooo00<000000?ooo`3oool0903oool20000
02T0oooo00<000000?ooo`3oool08`3oool010000000oooo0;Yb001b^^XX0?ooo`030000003oool0
oooo0240oooo00H0omBK0000V`000000oooo0=BK002Ke?lc0?ooo`00303oool00`000000oooo0?oo
o`0S0?ooo`090000003oool0oooo0?ooo`3Z^W8009_D0?ooo`3DV`00VmCo02<0oooo00<000000?oo
o`3oool08`3oool00`000000oooo0?ooo`040?ooo`030;YbV`3Dool0oooo0240oooo00<000000?oo
o`3oool0903oool4000002L0oooo00<000000?ooo`3oool08`3oool01@000000oooo0?ooo`2jLY/0
e?oo02L0oooo00<000000?ooo`3oool08P3oool01@3Z^W8000000?ooo`3DV`00VmCo03<0oooo000<
0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool00P3oool0102jLP00L[[Z0=BK002K
e?lS0?ooo`030000003oool0oooo02<0oooo00@000000?ooo`3Z^W80VmCo0`3oool00`3DV`00VmCo
0?ooo`0Q0?ooo`030000003oool0oooo02@0oooo0P00000Y0?ooo`030000003oool0oooo0240oooo
00<0j[Yb09_Do`0000000P3oool00`3DV`00VmCo0?ooo`0V0?ooo`030000003oool0oooo02<0oooo
00@0000007:jjP3DV`00VmCo<`3oool000`0oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`020?ooo`040?oZ^P1b0780LW8009_Dob<0oooo00<000000?ooo`3oool08`3oool02@000000
oooo0?oDV`0009/0e?oo0?ooo`3oe9/0001b0;[Zo`0R0?ooo`030000003oool0oooo02@0oooo0P00
000Y0?ooo`030000003oool0oooo0240oooo00L0omBK0000V`000000oooo0?oDV`000780^^[o02L0
oooo00<000000?ooo`3oool08`3oool010000000LP1b079b002Ke?lc0?ooo`00303oool00`000000
oooo0?ooo`0S0?ooo`030000003oool0oooo00<0oooo00<0omBK0000002Ke?l08`3oool00`000000
oooo0?ooo`0S0?ooo`040000003oool0oooo0?oDV`80000000<0001b0;[Zo`3oool08P3oool00`00
0000oooo0?ooo`0T0?ooo`800000:@3oool00`000000oooo0?ooo`0R0?ooo`050?oDV`0000000000
0000LP2jj_l0:03oool00`000000oooo0?ooo`0S0?ooo`040000003oe9/0000009_Doc<0oooo000<
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0903oool2000002T0oooo00<00000
0?ooo`3oool08`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool0=03oool000`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0X0?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0T0?oo
o`800000:@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02T0oooo00<000000?oo
o`3oool08`3oool00`000000oooo0?ooo`0d0?ooo`00303oool00`000000oooo0?ooo`0T0?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0W0?ooo`03
0000003oool0oooo02@0oooo0P00000Y0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool09`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo03@0oooo000<0?ooo`030000
003oool0oooo02@0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo02L0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0W0?ooo`030000
003oool0oooo02@0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0T0?ooo`030000
003oool0oooo03@0oooo000<0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo03<0oooo000;0?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo03<0oooo000;0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09`3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09`3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo03<0oooo000;0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo03<0
oooo000;0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09`3oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09`3oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo03<0oooo00000`3oool000000000003o00000:`000000P3o
ool000/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`8000004`3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool02P3oool0
03@0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`8000009`3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0:0?ooo`00=03oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02L0
oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0:0?ooo`00=03oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`0V0?ooo`8000009P3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00X0oooo
000d0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo02L0oooo0P00000V0?ooo`030000003oool0oooo02L0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool02P3oool003@0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0W
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool09`3oool2000002H0oooo00<00000
0?ooo`3oool09`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02L0oooo00<00000
0?ooo`3oool0903oool00`000000oooo0?ooo`0;0?ooo`00=03oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo02L0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0W0?oo
o`8000009P3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00/0oooo000d0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0T0?ooo`03
0000003oool0oooo02L0oooo0P00000V0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3o
ool09@3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool02`3oool003D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0W0?ooo`030000
003oool0oooo02@0oooo00<000000?ooo`3oool09`3oool2000002H0oooo00<000000?ooo`3oool0
9`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0
903oool00`000000oooo0?ooo`0;0?ooo`00=@3oool00`000000oooo0?ooo`0T0?ooo`030000003o
ool0oooo02P0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0W0?ooo`8000009P3o
ool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00/0oooo000e0?ooo`030000003oool0
oooo02@0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo02L0oooo0P00000V0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool02`3oool0
03D0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo
02<0oooo00<000000?ooo`3oool09`3oool3000002D0oooo00<000000?ooo`3oool0:03oool00`00
0000oooo0?ooo`0S0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`0;0?ooo`00=@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02T0
oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0000002@0
oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02P0
oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0;0?ooo`00=@3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0000002@0oooo00<000000?ooo`3oool0:@3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0903oool00`000000oooo
0?ooo`0;0?ooo`00=@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02T0oooo00<0
00000?ooo`3oool08P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0000002@0oooo00<0
00000?ooo`3oool0:@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02T0oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`0;0?ooo`00=@3oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0X
0?ooo`030000003oool0000002@0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0<
0?ooo`00=@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02T0oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0000002@0oooo00<000000?oo
o`3oool0:@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02T0oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`0<0?ooo`00=P3oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0X0?ooo`03
0000003oool0000002@0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0<0?ooo`00
=P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0
8@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0000002@0oooo00<000000?ooo`3oool0
:@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0
8P3oool00`000000oooo0?ooo`0<0?ooo`00=P3oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo02X0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0000002@0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo02X0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0<0?ooo`00=P3oool0
0`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`0X0?ooo`030000003oool0000002@0oooo00<000000?ooo`3oool0:P3oool0
0`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool08P3oool0
0`000000oooo0?ooo`0<0?ooo`00=P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
02/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool00000
02@0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
02X0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0<0?ooo`00=P3oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool08@3oool00`000000
oooo0?ooo`0X0?ooo`040000003oool0oooo00000280oooo00<000000?ooo`3oool0:`3oool00`00
0000oooo0?ooo`0Q0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool08@3oool00`00
0000oooo0?ooo`0<0?ooo`00=P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02/0
oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0X0?ooo`040000003oool0oooo0000
0280oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
02/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0<0?ooo`00=P3oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`0Y0?ooo`@000008P3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo0240
oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00`0
oooo000f0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0:`3oool00`000000oooo
0?ooo`0P0?ooo`030000003oool0oooo02T0oooo00@000000?ooo`3oool000008P3oool00`000000
oooo0?ooo`0[0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0:`3oool00`000000
oooo0?ooo`0P0?ooo`030000003oool0oooo00d0oooo000f0?ooo`030000003oool0oooo0240oooo
00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02T0oooo
00@000000?ooo`3oool000008P3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo0240
oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00d0
oooo000g0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0;03oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo02T0oooo00@000000?ooo`3oool000008P3oool00`000000
oooo0?ooo`0[0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0:`3oool00`000000
oooo0?ooo`0P0?ooo`030000003oool0oooo00d0oooo000g0?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo02T0oooo
00@000000?ooo`3oool000008P3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00d0
oooo000g0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0;03oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo02T0oooo00@000000?ooo`3oool000008P3oool00`000000
oooo0?ooo`0/0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0;03oool00`000000
oooo0?ooo`0P0?ooo`030000003oool0oooo00d0oooo000g0?ooo`030000003oool0oooo01l0oooo
00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo02T0oooo
00@000000?ooo`3oool000008P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo01l0
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00d0
oooo000g0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0;@3oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo02T0oooo00@000000?ooo`3oool000008@3oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0;@3oool00`000000
oooo0?ooo`0O0?ooo`030000003oool0oooo00d0oooo000g0?ooo`030000003oool0oooo01l0oooo
00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo02T0oooo
00D000000?ooo`3oool0oooo0000000P0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3o
ool07`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool03@3oool003L0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0]0?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool0:P3oool01@000000oooo0?ooo`3oool000000200
oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo02d0
oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0=0?ooo`00=`3oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`0Z0?ooo`050000003oool0oooo0?ooo`000000803oool00`000000oooo0?ooo`0]0?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0O0?ooo`03
0000003oool0oooo00d0oooo000g0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0
;P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02X0oooo00D000000?ooo`3oool0
oooo0000000P0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool07`3oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool03P3oool003L0oooo
00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool0:P3oool3000000030?ooo`000000oooo01l0oooo00<000000?ooo`3oool0
;@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0
7P3oool00`000000oooo0?ooo`0>0?ooo`00>03oool00`000000oooo0?ooo`0N0?ooo`030000003o
ool0oooo02h0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0Z0?ooo`050000003o
ool0oooo0?ooo`000000803oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01h0oooo
00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00h0oooo
000h0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?oo
o`0M0?ooo`030000003oool0oooo02X0oooo00D000000?ooo`3oool0oooo0000000P0?ooo`030000
003oool0oooo02d0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0^0?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool03P3oool003P0oooo00<000000?ooo`3oool07@3o
ool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0:P3o
ool01@000000oooo0?ooo`3oool000000200oooo00<000000?ooo`3oool0;P3oool00`000000oooo
0?ooo`0M0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`0>0?ooo`00>03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02l0oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`0Z0?ooo`050000003oool0oooo0?ooo`000000
7`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0
;`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00h0oooo000h0?ooo`030000003o
ool0oooo01d0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo02X0oooo00D000000?ooo`3oool0oooo0000000O0?ooo`030000003oool0oooo02l0oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool03P3oool003P0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?oo
o`0_0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?oo
o`0M0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?oo
o`0>0?ooo`00>03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02l0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01d0oooo00<00000
0?ooo`3oool0;`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00h0oooo000h0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0L0?oo
o`030000003oool0oooo02l0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool03P3oool003P0oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3o
ool0:`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3o
ool0;`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3o
ool0703oool00`000000oooo0?ooo`0?0?ooo`00>03oool00`000000oooo0?ooo`0L0?ooo`030000
003oool0oooo0340oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0[0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0_0?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0L0?ooo`030000
003oool0oooo00l0oooo000i0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0<@3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool03`3o
ool003T0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo0340oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0?0?ooo`00>@3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0[0?ooo`<000000P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool03`3oool003T0oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`0a0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0:`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`0K0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`0?0?ooo`00>@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0340oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01/0oooo
00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00l0oooo
000i0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?oo
o`0K0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool06`3oool00`000000oooo0?oo
o`0a0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool03`3oool003T0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo01T0oooo00<00000
0?ooo`3oool0;03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool0<@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0380oooo00<00000
0?ooo`3oool06`3oool00`000000oooo0?ooo`0?0?ooo`00>@3oool00`000000oooo0?ooo`0J0?oo
o`030000003oool0oooo03<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0/0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0a0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo00l0oooo000i0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool0<`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool0403oool003T0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0c0?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo03<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0@0?ooo`00>P3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0<`3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0100oooo000j0?ooo`030000003oool0
oooo01T0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo00h0oooo00D0omBK000000000000000009_Do`050?ooo`030=BK0000000009_D00D0oooo00D0
e9/0000000000000000009_Do`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
6P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
<`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0100oooo000j0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo00h0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK0000000009_D00@0
oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo00H0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0c0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0403oool0
03X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool03@3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo
00l0oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
03<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0@0?ooo`00>P3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0=0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool03`3oool00`3oe9/0
09_D0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0c0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=03oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo0100oooo000j0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00d0oooo
00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb002Ke?l0oooo00D0oooo
100000030?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=03oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0@0?ooo`00>P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03D0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0>0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0
omBK002Ke03oool02P3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo00D0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03@0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool0403oool003X0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0e
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool03P3oool00`3oe9/0L[[Z0?ooo`02
0?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0A
0?ooo`00>`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03D0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0?0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3o
ool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0=@3o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0140oooo000k0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo00l0oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K000000000080000000<0
002K0=Coo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool0=03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03D0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`00>`3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0]
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0d
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo0140oooo000k0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool0=@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo02d0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03D0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool04@3oool003/0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo03D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`00
>`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0140oooo000k0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo02h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo03H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0f0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool04P3oool003`0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0;P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0B0?ooo`00?03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
0180oooo000l0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0=`3oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo02h0oooo0`0000050?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03L0
oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0B0?ooo`00?03oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0^0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0f0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0=`3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo0180oooo000l0?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool0>03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02h0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03L0oooo00<0
00000?ooo`3oool05@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool04P3oool003`0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0h
0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0D
0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0B
0?ooo`00?@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03P0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool0>03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01<0oooo000m0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo02l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo03P0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0h0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool04`3oool003d0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
;`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
>03oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0C0?ooo`00?@3oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo03T0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0_0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0h0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo01<0oooo000m0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0>@3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0i0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04`3oool0
03d0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
03T0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0C0?ooo`00?@3oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`0_0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`0j0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0>@3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo01<0oooo000n0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo02l0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool0503oool003h0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0<03oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0D0?ooo`00?P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool04P3oool00`000000oooo0?ooo`0`0?ooo`<00000203oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0503oool003h0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0<03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0>`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03/0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0D0?ooo`00?P3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo03/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0`0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0k0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01@0oooo000n0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
?03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
503oool003h0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0l0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo03/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0D0?ooo`00?P3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0`0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0l0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0>`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01D0oooo000o0?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
03`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool05@3oool003l0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0l0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0?03oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0E0?ooo`00?`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03`0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01D0oooo
000o0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0m0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool05@3oool003l0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool0<@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool0?@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03d0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0E0?ooo`00?`3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo03h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0a0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0n0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo01H0oooo000o0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool0?P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool05P3oool00400oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0n0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool0<P3oool3000000T0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
?P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01H0oooo00100?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo0380oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo03l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0o0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool05P3oool00400oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0<P3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0?`3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0F0?ooo`00@03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
0400oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
01H0oooo00100?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0@03oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`100?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool05P3oool00400oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0400oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0G0?ooo`00@@3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0c0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`100?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo01L0oooo00110?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0@@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03<0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0440oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool05`3oool00440oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`110?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo0480oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0G0?oo
o`00@@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0@P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01L0oooo00110?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo03@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo0480oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`120?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0603oool00480oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`130?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0=03o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0@`3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0H0?ooo`00@P3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo04<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0d0?ooo`<000002`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`130?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool06@3oool0
0480oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
04@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0I0?ooo`00@P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0e0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`140?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0A03oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo01T0oooo00130?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo03D0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo04D0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool06P3oool004<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`150?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0J0?ooo`00@`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo04H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0AP3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01X0oooo00140?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo03H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo04H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`160?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool06P3oool004@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0=`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0A`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0K0?ooo`00A@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo04L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0g0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`170?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo01/0oooo00150?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0B@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02X0oooo00<0omBK0000000000000`00
00000`00Vm@0oooo0?ooo`040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`190?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0B@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01/0oooo00160?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo02h0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo04X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0L0?ooo`00AP3oool01@00
0000oooo0?ooo`3oool0000004`0oooo0P0000030?ooo`030000003oool0oooo02h0oooo00<0^W9b
0;[Zo`3oool01`3oool00`000000oooo0?ooo`0?0?ooo`050000003oool0oooo0?ooo`000000C@3o
ool01@000000oooo0?ooo`3oool0000004d0oooo00D000000?ooo`3oool0oooo0000000N0?ooo`00
A`3oool010000000oooo00000000001=0?ooo`80000000<0oooo000000000000<03oool00`2jLW80
^^[o0?ooo`070?ooo`030000003oool0oooo0100oooo1000001=0?ooo`80000000<0oooo00000000
0000C@3oool2000000030?ooo`000000oooo01h0oooo00170?ooo`<00000C`3oool200000380oooo
00<0^W9b0;[Zo`3oool01`3oool400000100oooo0P00001?0?ooo`<00000C`3oool200000200oooo
003=0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0eP3oool00<d0oooo00<0^W9b
0;[Zo`3oool01`3oool00`000000oooo0?ooo`3F0?ooo`00bP3oool01@3Z^W800000001b^P2jLW80
^^[o00P0oooo00<000000?ooo`3oool0eP3oool00<`0oooo00<0j[Yb0000LP2jj_l0203oool00`00
0000oooo0?ooo`3F0?ooo`00e`3oool00`000000oooo0?ooo`3F0?ooo`00e`3oool00`000000oooo
0?ooo`3F0?ooo`00\
\>"],
  ImageRangeCache->{{{91.1875, 378.188}, {331.375, 154.438}} -> {-8.63701, 
  0.785644, 0.0368022, 0.0119094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.178315 0.0126338 [
[.02381 .16582 -6 -9 ]
[.02381 .16582 6 0 ]
[.2619 .16582 -6 -9 ]
[.2619 .16582 6 0 ]
[.7381 .16582 -3 -9 ]
[.7381 .16582 3 0 ]
[.97619 .16582 -3 -9 ]
[.97619 .16582 3 0 ]
[.4875 .05198 -18 -4.5 ]
[.4875 .05198 0 4.5 ]
[.4875 .30465 -12 -4.5 ]
[.4875 .30465 0 4.5 ]
[.4875 .43099 -12 -4.5 ]
[.4875 .43099 0 4.5 ]
[.4875 .55733 -12 -4.5 ]
[.4875 .55733 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .17832 m
.02381 .18457 L
s
[(-4)] .02381 .16582 0 1 Mshowa
.2619 .17832 m
.2619 .18457 L
s
[(-2)] .2619 .16582 0 1 Mshowa
.7381 .17832 m
.7381 .18457 L
s
[(2)] .7381 .16582 0 1 Mshowa
.97619 .17832 m
.97619 .18457 L
s
[(4)] .97619 .16582 0 1 Mshowa
.125 Mabswid
.08333 .17832 m
.08333 .18207 L
s
.14286 .17832 m
.14286 .18207 L
s
.20238 .17832 m
.20238 .18207 L
s
.32143 .17832 m
.32143 .18207 L
s
.38095 .17832 m
.38095 .18207 L
s
.44048 .17832 m
.44048 .18207 L
s
.55952 .17832 m
.55952 .18207 L
s
.61905 .17832 m
.61905 .18207 L
s
.67857 .17832 m
.67857 .18207 L
s
.79762 .17832 m
.79762 .18207 L
s
.85714 .17832 m
.85714 .18207 L
s
.91667 .17832 m
.91667 .18207 L
s
.25 Mabswid
0 .17832 m
1 .17832 L
s
.5 .05198 m
.50625 .05198 L
s
[(-10)] .4875 .05198 1 0 Mshowa
.5 .30465 m
.50625 .30465 L
s
[(10)] .4875 .30465 1 0 Mshowa
.5 .43099 m
.50625 .43099 L
s
[(20)] .4875 .43099 1 0 Mshowa
.5 .55733 m
.50625 .55733 L
s
[(30)] .4875 .55733 1 0 Mshowa
.125 Mabswid
.5 .07724 m
.50375 .07724 L
s
.5 .10251 m
.50375 .10251 L
s
.5 .12778 m
.50375 .12778 L
s
.5 .15305 m
.50375 .15305 L
s
.5 .20358 m
.50375 .20358 L
s
.5 .22885 m
.50375 .22885 L
s
.5 .25412 m
.50375 .25412 L
s
.5 .27939 m
.50375 .27939 L
s
.5 .32992 m
.50375 .32992 L
s
.5 .35519 m
.50375 .35519 L
s
.5 .38046 m
.50375 .38046 L
s
.5 .40572 m
.50375 .40572 L
s
.5 .45626 m
.50375 .45626 L
s
.5 .48153 m
.50375 .48153 L
s
.5 .50679 m
.50375 .50679 L
s
.5 .53206 m
.50375 .53206 L
s
.5 .02671 m
.50375 .02671 L
s
.5 .00144 m
.50375 .00144 L
s
.5 .5826 m
.50375 .5826 L
s
.5 .60787 m
.50375 .60787 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.16187 .61803 m
.16372 .60187 L
.18466 .45691 L
.20597 .34393 L
.22611 .26477 L
.2358 .23507 L
.24608 .20891 L
.25571 .18898 L
.26452 .17429 L
.27393 .16202 L
.27877 .15698 L
.28405 .1524 L
.28892 .14898 L
.29344 .14646 L
.29775 .1446 L
.29995 .14385 L
.30236 .14318 L
.30496 .14262 L
.30638 .14239 L
.30771 .14222 L
.30896 .1421 L
.31009 .14202 L
.3114 .14196 L
.31264 .14194 L
.31328 .14195 L
.31398 .14197 L
.31472 .14199 L
.31541 .14203 L
.31664 .14212 L
.31797 .14226 L
.31944 .14245 L
.32099 .1427 L
.32377 .14327 L
.32876 .14465 L
.3334 .14632 L
.34394 .15135 L
.36439 .16492 L
.38298 .18005 L
.42296 .21455 L
.44128 .22864 L
.45169 .23562 L
.46143 .24131 L
.47182 .24638 L
.48131 .25001 L
.48616 .25148 L
.49145 .25276 L
.49435 .25332 L
.49704 .25375 L
.49961 .25408 L
.50092 .25421 L
Mistroke
.50235 .25433 L
.5037 .25443 L
.50496 .25449 L
.50566 .25452 L
.5063 .25454 L
.50703 .25455 L
.50772 .25456 L
.50895 .25456 L
.51009 .25455 L
.51134 .25451 L
.51197 .25448 L
.51266 .25445 L
.51411 .25436 L
.51543 .25425 L
.51841 .25392 L
.52104 .25353 L
.5238 .25303 L
.5288 .25186 L
.53345 .25049 L
.54398 .24631 L
.55453 .24069 L
.56448 .2341 L
.58308 .21857 L
.6216 .17504 L
.66257 .11821 L
.70203 .06391 L
.72186 .04113 L
.73053 .03287 L
.73997 .02535 L
.74516 .02197 L
.74997 .01936 L
.75456 .01737 L
.75711 .0165 L
.75945 .01584 L
.76191 .01531 L
.76321 .01509 L
.76457 .01492 L
.76576 .01481 L
.76687 .01474 L
.76809 .01472 L
.76938 .01473 L
.77012 .01476 L
.7708 .01481 L
.77155 .01487 L
.77234 .01496 L
.77367 .01515 L
.77513 .01543 L
.77783 .01612 L
.78036 .01699 L
.78533 .01933 L
Mistroke
.79075 .02292 L
.79587 .02733 L
.80062 .03237 L
.80959 .04452 L
.81915 .06155 L
.82944 .08501 L
.84058 .11692 L
.86075 .19408 L
.88071 .29824 L
.90177 .44283 L
.92012 .60152 L
Mfstroke
.92012 .60152 m
.92167 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oe`3oool3
00000=H0oooo003G0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`030000003oool0oooo0=H0
oooo003G0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`030000003oool0oooo0=H0oooo003G
0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`030000003oool0oooo06d0oooo1`00001R0?oo
o`00e`3oool00`000000oooo0?ooo`1[0?ooo`8000001`3oool3000005l0oooo003G0?ooo`030000
003oool0oooo06P0oooo0`00000<0?ooo`800000G@3oool00=L0oooo00<000000?ooo`3oool0IP3o
ool200000140oooo0P00001K0?ooo`00e`3oool00`000000oooo0?ooo`1U0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0F03oool00=L0oooo0`00001T0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0E`3oool00=L0oooo00<000000?ooo`3oool0H`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo05H0oooo003G0?ooo`030000003oool0oooo0640oooo
0P00000J0?ooo`030000003oool0oooo05H0oooo003G0?ooo`030000003oool0oooo0600oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`1E0?ooo`00e`3oool00`000000oooo0?ooo`1O
0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0E03oool00=L0oooo00<000000?oo
o`3oool0G@3oool200000240oooo00<000000?ooo`3oool0D`3oool00=L0oooo00<000000?ooo`3o
ool0G03oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo05<0oooo00310?ooo`030?oD
V`000000000000<0000000D009_D0?ooo`3oool0oooo0?oDV`030000000309_Do`3oool0oooo00D0
oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0580
oooo00340?ooo`030;YbLP2jj_l0oooo00@0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool60?oo
o`030000003oool0oooo05X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1A0?oo
o`00a03oool00`2jLW80^^[o0?ooo`030?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3o
ool01@3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool0D03oool00<@0oooo00<0^W9b0;[Zo`3oool00`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oD
V`00Vm@0oooo00D0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0W0?ooo`030000
003oool0oooo0500oooo002h0?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool00`3o
ool00`2jLW80^^[o0?ooo`030?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool01@3o
ool4000005L0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1?0?ooo`00a03oool0
0`2jLW80^^[o0?ooo`030?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool01@3oool0
0`000000oooo0?ooo`1G0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0C`3oool0
0<@0oooo00<0^W9b0;[Zo`3oool00`3oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo
00D0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo
04h0oooo00310?ooo`050>ZjLP00000007:j0;YbLP2jj_l01@3oool01P2jLP00VmCo0?ooo`3oj[X0
LP2K0=Coo`H0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0/0?ooo`030000003o
ool0oooo04h0oooo00330?ooo`030>ZjLP000780^^[o00D0oooo00D0oooD09/000000000001b0;[Z
o`070?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?oo
o`1=0?ooo`00e`3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo02l0oooo00<00000
0?ooo`3oool0C@3oool00=L0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0a0?oo
o`030000003oool0oooo04`0oooo003G0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3o
ool0<@3oool00`000000oooo0?ooo`1<0?ooo`00e`3oool00`000000oooo0?ooo`1B0?ooo`030000
003oool0oooo03<0oooo00<000000?ooo`3oool0B`3oool00=L0oooo00<000000?ooo`3oool0D@3o
ool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo04/0oooo003G0?ooo`030000003oool0
oooo0500oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`1:0?ooo`00e`3oool30000
0500oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`1:0?ooo`00e`3oool00`000000
oooo0?ooo`1?0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0B@3oool00=L0oooo
00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo04T0oooo
003G0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?oo
o`180?ooo`00e`3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo03/0oooo00<00000
0?ooo`3oool0B03oool00=L0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`0m0?oo
o`030000003oool0oooo04L0oooo003G0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3o
ool0?P3oool00`000000oooo0?ooo`170?ooo`00e`3oool00`000000oooo0?ooo`1:0?ooo`030000
003oool0oooo03l0oooo00<000000?ooo`3oool0A`3oool00=L0oooo00<000000?ooo`3oool0BP3o
ool00`000000oooo0?ooo`100?ooo`030000003oool0oooo04H0oooo003G0?ooo`030000003oool0
oooo04T0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`160?ooo`00e`3oool00`00
0000oooo0?ooo`180?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0AP3oool00=L0
oooo0`0000170?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0A@3oool00=L0oooo
00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo04D0oooo
003G0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?oo
o`140?ooo`00e`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo04L0oooo00<00000
0?ooo`3oool0A03oool00=L0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`180?oo
o`030000003oool0oooo04@0oooo003G0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3o
ool0B@3oool00`000000oooo0?ooo`130?ooo`00e`3oool00`000000oooo0?ooo`130?ooo`030000
003oool0oooo04X0oooo00<000000?ooo`3oool0@`3oool00=L0oooo00<000000?ooo`3oool0@P3o
ool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo04<0oooo003G0?ooo`030000003oool0
oooo0480oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`130?ooo`00e`3oool00`00
0000oooo0?ooo`110?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool0@P3oool00=L0
oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo0480
oooo003G0?ooo`<00000?`3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo0480oooo
003G0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?oo
o`120?ooo`00e`3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo0540oooo00<00000
0?ooo`3oool0@@3oool00=L0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`1B0?oo
o`030000003oool0oooo0440oooo000=0?ooo`050?oZ^P1b000000000000002Ke?l0G`3oool00`3o
om@0V`00000000040000000309_Do`3oool0oooo05`0oooo00<000000?ooo`3oool0?@3oool00`00
0000oooo0?ooo`0O0?ooo`030?ooe02K0000000000@0000000<0VmCo0?ooo`3oool0:@3oool00`00
0000oooo0?ooo`0c0?ooo`050?oZ^P1b000000000000002Ke?l02@3oool000l0oooo00<0e9/009_D
o`3oool0H03oool00`3DV`00002K0=Coo`020?ooo`030>ZjV`2jj_l0oooo05d0oooo00<000000?oo
o`3oool0?03oool00`000000oooo0?ooo`0Q0?ooo`030=BK000009/0e?oo0080oooo00<0j[ZK0;[Z
o`3oool0:P3oool00`000000oooo0?ooo`0e0?ooo`030=BK002Ke?l0oooo00T0oooo000?0?ooo`03
0=BK002Ke?l0oooo0640oooo00<0omBK0000LP2jj_l0303oool:000004/0oooo00<000000?ooo`3o
ool0>`3oool00`000000oooo0?ooo`0S0?ooo`030?oDV`000780^^[o02l0oooo00<000000?ooo`3o
ool0=03oool00`3DV`00VmCo0?ooo`090?ooo`002`3oool00`3Z^W800000000000030000000309_D
o`3oool0oooo0600oooo00<0onZj0780001b^^X02@3oool2000000X0oooo0P0000190?ooo`030000
003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`3oj[X0LP0007:jjP0^0?ooo`030000
003oool0oooo0300oooo00<0j[Yb0000000000000`0000000`2Ke?l0oooo0?ooo`070?ooo`000P3o
ool00`2jLP0000000000000300000009001b^P3oool0oooo0?oDV`0009/0e?oo0?ooo`3DV`00VmCo
05P0oooo00<0^W800000000000000`0000000`00L[X0oooo0?ooo`040?ooo`030;Yb001b^^X0oooo
00D0oooo0P00000>0?ooo`<00000AP3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
02L0oooo00<0^W8007:jjP3oool0;03oool00`000000oooo0?ooo`0`0?ooo`060?oDV`0009/0e?oo
0?ooo`3DV`00VmCo2P3oool000`0oooo00D0j[Yb002Ke03oool0e9/009_Do`1V0?ooo`030;YbV`3D
ool0oooo0080oooo0P00000C0?ooo`800000A03oool00`000000oooo0?ooo`0i0?ooo`030000003o
ool0oooo02T0oooo00<0^W:K0=Coo`3oool0:`3oool00`000000oooo0?ooo`0a0?ooo`050>ZjLP00
Vm@0oooo0=BK002Ke?l02P3oool000d0oooo00@0^W8007:jjP3DV`00VmCoH@3oool00`3Z^W80VmCo
0?ooo`020?ooo`030=BK002Ke?l0oooo008000005`3oool200000480oooo0`00000h0?ooo`030000
003oool0oooo02D0oooo00<0j[Yb09_Do`3oool00P3oool00`3DV`00VmCo0?ooo`0/0?ooo`030000
003oool0oooo0340oooo00@0^W8007:jjP3DV`00VmCo2P3oool000d0oooo00@0onZj0780LP1bLP00
VmCoH@3oool0203oe9/0002K0=Coo`3oool0omBK0000LP2jj_l000006`3oool200000400oooo00<0
00000?ooo`3oool0=`3oool00`000000oooo0?ooo`0V0?ooo`070?oDV`0009/0e?oo0?ooo`3oe9/0
001b0;[Zo`0]0?ooo`030000003oool0oooo0340oooo00@0onZj0780LP1bLP00VmCo2P3oool000h0
oooo00<0omBK0000002Ke?l0HP3oool01P3oe9/00000000000000780^^[o000001h0oooo00<00000
0?ooo`3oool0?@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo02L0oooo00D0omBK
000000000000001b0;[Zo`0^0?ooo`030000003oool0oooo0380oooo00<0omBK0000002Ke?l02P3o
ool007L0oooo00<000000?ooo`3oool07P3oool2000003d0oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`1K0?ooo`030000003oool0oooo03l0oooo001f0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
05d0oooo00<000000?ooo`3oool0?P3oool007D0oooo00<000000?ooo`3oool08`3oool2000003X0
oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo03h0
oooo001e0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0=`3oool00`000000oooo
0?ooo`0d0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool0?P3oool007@0oooo00<0
00000?ooo`3oool09`3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool0G`3oool00`000000oooo0?ooo`0n0?ooo`00L`3oool00`000000oooo0?ooo`0Y
0?ooo`800000=P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0640oooo00<00000
0?ooo`3oool0?@3oool007<0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0c0?oo
o`030000003oool0oooo0380oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`0m0?oo
o`00LP3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3o
ool0<@3oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo03d0oooo003o00000;000000
0@3oool000X0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo01L0oooo0P00000G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0E0?ooo`8000006@3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool2
000001P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0000000F0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
000001T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo00T0oooo000:0?ooo`030000003oool0oooo0680oooo00<000000?ooo`000000=@3oool00`00
0000oooo0?ooo`0]0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0<P3oool00`00
0000oooo0?ooo`0a0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool02@3oool006l0
oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo02d0
oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`0l0?ooo`00KP3oool00`000000oooo
0?ooo`0h0?ooo`800000;03oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo06T0oooo
00<000000?ooo`3oool0>`3oool006d0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?oo
o`0Y0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0JP3oool00`000000oooo0?oo
o`0k0?ooo`00K@3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo02P0oooo00<00000
0?ooo`3oool0:P3oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo03/0oooo001/0?oo
o`030000003oool0oooo03h0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0Y0?oo
o`030000003oool0oooo06`0oooo00<000000?ooo`3oool0>`3oool006`0oooo00<000000?ooo`3o
ool0?`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3o
ool0K03oool00`000000oooo0?ooo`0k0?ooo`00J`3oool00`000000oooo0?ooo`110?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`1^0?ooo`030000
003oool0oooo03X0oooo001[0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0903o
ool3000002L0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`0j0?ooo`00JP3oool0
0`000000oooo0?ooo`140?ooo`800000903oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo0700oooo00<000000?ooo`3oool0>P3oool006X0oooo00<000000?ooo`3oool0AP3oool00`00
0000oooo0?ooo`0Q0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0L@3oool00`00
0000oooo0?ooo`0j0?ooo`00JP3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo03X0
oooo001Y0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool07`3oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo07<0oooo00<000000?ooo`3oool0>@3oool006T0oooo00<0
00000?ooo`3oool0BP3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo02<0oooo00<0
00000?ooo`3oool0M03oool00`000000oooo0?ooo`0i0?ooo`00J03oool00`000000oooo0?ooo`1<
0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`1e
0?ooo`030000003oool0oooo03T0oooo001X0?ooo`030000003oool0oooo04d0oooo0P00000M0?oo
o`030000003oool0oooo0240oooo00<000000?ooo`3oool0MP3oool00`000000oooo0?ooo`0i0?oo
o`00I`3oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo03T0oooo001W0?ooo`030000
003oool0oooo0540oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0N0?ooo`800000
N`3oool00`000000oooo0?ooo`0h0?ooo`00I`3oool00`000000oooo0?ooo`1B0?ooo`8000006@3o
ool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo07/0oooo00<000000?ooo`3oool0>03o
ool006H0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0F0?ooo`<00000703oool0
0`000000oooo0?ooo`1l0?ooo`030000003oool0oooo03P0oooo001V0?ooo`030000003oool0oooo
05H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0J0?ooo`800000O`3oool00`00
0000oooo0?ooo`0h0?ooo`00I@3oool00`000000oooo0?ooo`1H0?ooo`8000005@3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo07l0oooo00<000000?ooo`3oool0>03oool006D0oooo
00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01L0oooo
0P0000230?ooo`030000003oool0oooo03L0oooo001U0?ooo`030000003oool0oooo05/0oooo0P00
000B0?ooo`030000003oool0oooo01D0oooo0P0000250?ooo`030000003oool0oooo03L0oooo001T
0?ooo`030000003oool0oooo05h0oooo0P00000@0?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool0Q@3oool00`000000oooo0?ooo`0g0?ooo`00I03oool00`000000oooo0?ooo`1P0?oo
o`8000003P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo08H0oooo00<000000?oo
o`3oool0=`3oool006@0oooo00<000000?ooo`3oool0HP3oool2000000`0oooo00<000000?ooo`3o
ool04@3oool2000008T0oooo00<000000?ooo`3oool0=`3oool006<0oooo00<000000?ooo`3oool0
I@3oool2000000X0oooo00<000000?ooo`3oool03P3oool3000008`0oooo00<000000?ooo`3oool0
=P3oool006<0oooo00<000000?ooo`3oool0I`3oool3000000L0oooo00<000000?ooo`3oool02`3o
ool3000008l0oooo00<000000?ooo`3oool0=P3oool006<0oooo00<000000?ooo`3oool0JP3oool4
000000<0oooo00<000000?ooo`3oool01`3oool400000980oooo00<000000?ooo`3oool0=P3oool0
06<0oooo00<000000?ooo`3oool0KP3oool=000009H0oooo00<000000?ooo`3oool0=P3oool00680
oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`2M0?ooo`030000003oool0oooo03H0
oooo001R0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0WP3oool00`000000oooo
0?ooo`0e0?ooo`00HP3oool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo09h0oooo00<0
00000?ooo`3oool0=@3oool00640oooo00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`2N
0?ooo`030000003oool0oooo03D0oooo001Q0?ooo`030000003oool0oooo07<0oooo00<000000?oo
o`3oool0WP3oool00`000000oooo0?ooo`0e0?ooo`00H@3oool00`000000oooo0?ooo`1c0?ooo`03
0000003oool0oooo09h0oooo00<000000?ooo`3oool0=@3oool00640oooo00<000000?ooo`3oool0
L`3oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo03@0oooo001P0?ooo`030000003o
ool0oooo07@0oooo00<000000?ooo`3oool0W`3oool00`000000oooo0?ooo`0d0?ooo`00H03oool0
0`000000oooo0?ooo`1d0?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3oool0=03oool0
0600oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo
03@0oooo001P0?ooo`030000003oool0oooo07@0oooo0`00002O0?ooo`030000003oool0oooo03@0
oooo001O0?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool0X03oool00`000000oooo
0?ooo`0c0?ooo`00G`3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo0:00oooo00<0
00000?ooo`3oool0<`3oool005l0oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`2P
0?ooo`030000003oool0oooo03<0oooo001O0?ooo`030000003oool0oooo07D0oooo00<000000?oo
o`3oool0X03oool00`000000oooo0?ooo`0c0?ooo`00GP3oool00`000000oooo0?ooo`1f0?ooo`03
0000003oool0oooo0:00oooo00<000000?ooo`3oool0<`3oool005h0oooo00<000000?ooo`3oool0
MP3oool00`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo0380oooo001N0?ooo`030000003o
ool0oooo0600oooo00<0omBK0000000000000`0000001@00Vm@0oooo0?ooo`3oool0omBK00<00000
00<0VmCo0?ooo`3oool01@3oool00`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo0380oooo
001N0?ooo`030000003oool0oooo06<0oooo00<0^W9b0;[Zo`3oool0103oool01P2jLY/0e?oo0?oo
o`3oom@0V`2K0=Coo`H0oooo00<000000?ooo`3oool0X@3oool00`000000oooo0?ooo`0b0?ooo`00
G@3oool00`000000oooo0?ooo`1T0?ooo`030;YbLP2jj_l0oooo00<0oooo00<0omBK002Ke03oool0
0P3oool00`3Z^W80L[[Z0?ooo`050?ooo`030000003oool0oooo0:40oooo00<000000?ooo`3oool0
<P3oool005d0oooo00<000000?ooo`3oool0I03oool00`2jLW80^^[o0?ooo`030?ooo`030>ZjLP1b
^^X0oooo0080oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?ooo`2Q0?ooo`030000003o
ool0oooo0380oooo001M0?ooo`030000003oool0oooo06@0oooo00<0^W9b0;[Zo`3oool00`3oool0
0`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00D0oooo1000002P0?ooo`030000003oool0
oooo0380oooo001M0?ooo`030000003oool0oooo06@0oooo00<0^W9b0;[Zo`3oool00`3oool00`3Z
^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00D0oooo00<000000?ooo`3oool0XP3oool00`00
0000oooo0?ooo`0a0?ooo`00G@3oool00`000000oooo0?ooo`1T0?ooo`030;YbLP2jj_l0oooo00<0
oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`050?ooo`030000003oool0oooo0:80
oooo00<000000?ooo`3oool0<@3oool005`0oooo00<000000?ooo`3oool0HP3oool01@3Z^W800000
001b^P2jLW80^^[o00D0oooo00H0^W8009_Do`3oool0onZj0780V`3Dool60?ooo`030000003oool0
oooo0:80oooo00<000000?ooo`3oool0<@3oool005`0oooo00<000000?ooo`3oool0I03oool00`3Z
^W80001b0;[Zo`050?ooo`050?ooe02K000000000000LP2jj_l01`3oool00`000000oooo0?ooo`2R
0?ooo`030000003oool0oooo0340oooo001L0?ooo`030000003oool0oooo07P0oooo00<000000?oo
o`3oool0XP3oool00`000000oooo0?ooo`0a0?ooo`00G03oool00`000000oooo0?ooo`1h0?ooo`03
0000003oool0oooo0:80oooo00<000000?ooo`3oool0<@3oool005/0oooo00<000000?ooo`3oool0
N@3oool00`000000oooo0?ooo`2R0?ooo`030000003oool0oooo0340oooo001K0?ooo`030000003o
ool0oooo07T0oooo00<000000?ooo`3oool0X`3oool00`000000oooo0?ooo`0`0?ooo`00F`3oool0
0`000000oooo0?ooo`1i0?ooo`030000003oool0oooo0:<0oooo00<000000?ooo`3oool0<03oool0
05/0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`2S0?ooo`030000003oool0oooo
0300oooo001J0?ooo`030000003oool0oooo07X0oooo0`00002S0?ooo`030000003oool0oooo0300
oooo001J0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0X`3oool00`000000oooo
0?ooo`0`0?ooo`00FP3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo0:<0oooo00<0
00000?ooo`3oool0<03oool005X0oooo00<000000?ooo`3oool0NP3oool00`000000oooo0?ooo`2S
0?ooo`030000003oool0oooo0300oooo001I0?ooo`030000003oool0oooo07/0oooo00<000000?oo
o`3oool0Y03oool00`000000oooo0?ooo`0_0?ooo`00F@3oool00`000000oooo0?ooo`1k0?ooo`03
0000003oool0oooo0:@0oooo00<000000?ooo`3oool0;`3oool005T0oooo00<000000?ooo`3oool0
N`3oool00`000000oooo0?ooo`2T0?ooo`030000003oool0oooo02l0oooo001I0?ooo`030000003o
ool0oooo07/0oooo00<000000?ooo`3oool0Y03oool00`000000oooo0?ooo`0_0?ooo`00F@3oool0
0`000000oooo0?ooo`1k0?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3oool0;`3oool0
05P0oooo00<000000?ooo`3oool0O03oool00`000000oooo0?ooo`2T0?ooo`030000003oool0oooo
02l0oooo001H0?ooo`030000003oool0oooo07`0oooo0`00002T0?ooo`030000003oool0oooo02l0
oooo001H0?ooo`030000003oool0oooo07`0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo
0?ooo`0^0?ooo`00F03oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo0:D0oooo00<0
00000?ooo`3oool0;P3oool005P0oooo00<000000?ooo`3oool0O03oool00`000000oooo0?ooo`2U
0?ooo`030000003oool0oooo02h0oooo001G0?ooo`030000003oool0oooo07d0oooo00<000000?oo
o`3oool0Y@3oool00`000000oooo0?ooo`0^0?ooo`00E`3oool00`000000oooo0?ooo`1m0?ooo`03
0000003oool0oooo0:D0oooo00<000000?ooo`3oool0;P3oool005L0oooo00<000000?ooo`3oool0
O@3oool00`000000oooo0?ooo`2U0?ooo`030000003oool0oooo02h0oooo001G0?ooo`030000003o
ool0oooo07d0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?ooo`0^0?ooo`00EP3oool0
0`000000oooo0?ooo`1n0?ooo`030000003oool0oooo0:H0oooo00<000000?ooo`3oool0;@3oool0
05H0oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?ooo`2V0?ooo`030000003oool0oooo
02d0oooo001F0?ooo`030000003oool0oooo07h0oooo00<000000?ooo`3oool0YP3oool00`000000
oooo0?ooo`0]0?ooo`00EP3oool00`000000oooo0?ooo`1n0?ooo`<00000YP3oool00`000000oooo
0?ooo`0]0?ooo`00EP3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo0:H0oooo00<0
00000?ooo`3oool0;@3oool005D0oooo00<000000?ooo`3oool0O`3oool00`000000oooo0?ooo`2V
0?ooo`030000003oool0oooo02d0oooo001E0?ooo`030000003oool0oooo07l0oooo00<000000?oo
o`3oool0Y`3oool00`000000oooo0?ooo`0/0?ooo`00E@3oool00`000000oooo0?ooo`1o0?ooo`03
0000003oool0oooo0:L0oooo00<000000?ooo`3oool0;03oool005D0oooo00<000000?ooo`3oool0
O`3oool00`000000oooo0?ooo`2W0?ooo`030000003oool0oooo02`0oooo001E0?ooo`030000003o
ool0oooo07l0oooo00<000000?ooo`3oool0Y`3oool00`000000oooo0?ooo`0/0?ooo`00E03oool0
0`000000oooo0?ooo`200?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool0;03oool0
05@0oooo00<000000?ooo`3oool0P03oool00`000000oooo0?ooo`2W0?ooo`030000003oool0oooo
02`0oooo001D0?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool0Y`3oool00`000000
oooo0?ooo`0/0?ooo`00E03oool00`000000oooo0?ooo`200?ooo`030000003oool0oooo0:P0oooo
00<000000?ooo`3oool0:`3oool005@0oooo00<000000?ooo`3oool0P03oool300000:P0oooo00<0
00000?ooo`3oool0:`3oool005<0oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`2X
0?ooo`030000003oool0oooo02/0oooo001C0?ooo`030000003oool0oooo0840oooo00<000000?oo
o`3oool0Z03oool00`000000oooo0?ooo`0[0?ooo`00D`3oool00`000000oooo0?ooo`210?ooo`03
0000003oool0oooo0:P0oooo00<000000?ooo`3oool0:`3oool005<0oooo00<000000?ooo`3oool0
P@3oool00`000000oooo0?ooo`2X0?ooo`030000003oool0oooo02/0oooo001C0?ooo`030000003o
ool0oooo0840oooo00<000000?ooo`3oool0Z03oool00`000000oooo0?ooo`0[0?ooo`00DP3oool0
0`000000oooo0?ooo`220?ooo`030000003oool0oooo0:T0oooo00<000000?ooo`3oool0:P3oool0
0580oooo00<000000?ooo`3oool0PP3oool00`000000oooo0?ooo`2Y0?ooo`030000003oool0oooo
02X0oooo001B0?ooo`030000003oool0oooo06/0oooo00<0oooD09/000000000100000001@2Ke?l0
oooo0?ooo`3oool0omBK00<0000000<0VmCo0?ooo`3oool01@3oool00`000000oooo0?ooo`2Y0?oo
o`030000003oool0oooo02X0oooo001B0?ooo`030000003oool0oooo06`0oooo00<0e9/00000V`3D
ool00P3oool00`3Z^Y/0^^[o0?ooo`020?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo1P3oool0
0`000000oooo0?ooo`2Y0?ooo`030000003oool0oooo02X0oooo001A0?ooo`030000003oool0oooo
06h0oooo00<0omBK0000LP2jj_l01@3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo
00D0oooo00<000000?ooo`3oool0Z@3oool00`000000oooo0?ooo`0Z0?ooo`00D@3oool00`000000
oooo0?ooo`1_0?ooo`030?oZ^P1b0000L[[Z00@0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/0
09_D0?ooo`050?ooo`@00000Z03oool00`000000oooo0?ooo`0Z0?ooo`00D@3oool00`000000oooo
0?ooo`1a0?ooo`030;Yb001b^^X0oooo0080oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D
0?ooo`050?ooo`030000003oool0oooo0:T0oooo00<000000?ooo`3oool0:P3oool00540oooo00<0
00000?ooo`3oool0LP3oool01P2jLY/0e?oo0?ooo`3oool0j[Yb07:jjP<0oooo00<0omBK002Ke03o
ool01@3oool00`000000oooo0?ooo`2Z0?ooo`030000003oool0oooo02T0oooo001A0?ooo`030000
003oool0oooo06d0oooo00<0j[Yb09_Do`3oool00P3oool01P3DV`00VmCo0?ooo`3oool0omBK07:j
jP<0oooo00<0j[Yb07:jjP3oool01@3oool00`000000oooo0?ooo`2Z0?ooo`030000003oool0oooo
02T0oooo001@0?ooo`030000003oool0oooo06h0oooo00L0omBK0000V`3Dool0oooo0?oDV`000780
^^[o00<0oooo00H0^W8009_Do`3oool0onZj0780V`3Dool60?ooo`030000003oool0oooo0:X0oooo
00<000000?ooo`3oool0:@3oool00500oooo00<000000?ooo`3oool0K`3oool01@3oe9/000000000
00000780^^[o00@0oooo00D0oooD09/000000000001b0;[Zo`070?ooo`030000003oool0oooo0:X0
oooo00<000000?ooo`3oool0:@3oool00500oooo00<000000?ooo`3oool0Q03oool00`000000oooo
0?ooo`2Z0?ooo`030000003oool0oooo02T0oooo001@0?ooo`030000003oool0oooo08@0oooo00<0
00000?ooo`3oool0ZP3oool00`000000oooo0?ooo`0Y0?ooo`00D03oool00`000000oooo0?ooo`24
0?ooo`030000003oool0oooo0:X0oooo00<000000?ooo`3oool0:@3oool004l0oooo00<000000?oo
o`3oool0Q@3oool00`000000oooo0?ooo`2Z0?ooo`030000003oool0oooo02T0oooo001?0?ooo`03
0000003oool0oooo08D0oooo00<000000?ooo`3oool0Z`3oool00`000000oooo0?ooo`0X0?ooo`00
C`3oool00`000000oooo0?ooo`250?ooo`<00000Z`3oool00`000000oooo0?ooo`0X0?ooo`00C`3o
ool00`000000oooo0?ooo`250?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`3oool0:03o
ool004l0oooo00<000000?ooo`3oool0Q@3oool00`000000oooo0?ooo`2[0?ooo`030000003oool0
oooo02P0oooo001?0?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3oool0Z`3oool00`00
0000oooo0?ooo`0X0?ooo`00CP3oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo0:/0
oooo00<000000?ooo`3oool0:03oool004h0oooo00<000000?ooo`3oool0QP3oool00`000000oooo
0?ooo`2[0?ooo`030000003oool0oooo02P0oooo001>0?ooo`030000003oool0oooo08H0oooo00<0
00000?ooo`3oool0Z`3oool00`000000oooo0?ooo`0X0?ooo`00CP3oool00`000000oooo0?ooo`26
0?ooo`030000003oool0oooo0:`0oooo00<000000?ooo`3oool09`3oool004h0oooo00<000000?oo
o`3oool0QP3oool00`000000oooo0?ooo`2/0?ooo`030000003oool0oooo02L0oooo001>0?ooo`03
0000003oool0oooo08H0oooo00<000000?ooo`3oool0[03oool00`000000oooo0?ooo`0W0?ooo`00
CP3oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo0:`0oooo00<000000?ooo`3oool0
9`3oool004d0oooo00<000000?ooo`3oool0Q`3oool300000:`0oooo00<000000?ooo`3oool09`3o
ool004d0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`2/0?ooo`030000003oool0
oooo02L0oooo001=0?ooo`030000003oool0oooo08L0oooo00<000000?ooo`3oool0[03oool00`00
0000oooo0?ooo`0W0?ooo`00C@3oool00`000000oooo0?ooo`270?ooo`030000003oool0oooo0:`0
oooo00<000000?ooo`3oool09`3oool004d0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo
0?ooo`2/0?ooo`030000003oool0oooo02L0oooo001=0?ooo`030000003oool0oooo08L0oooo00<0
00000?ooo`3oool0[@3oool00`000000oooo0?ooo`0V0?ooo`00C@3oool00`000000oooo0?ooo`27
0?ooo`030000003oool0oooo0:d0oooo00<000000?ooo`3oool09P3oool004`0oooo00<000000?oo
o`3oool0R03oool00`000000oooo0?ooo`2]0?ooo`030000003oool0oooo02H0oooo001<0?ooo`03
0000003oool0oooo08P0oooo00<000000?ooo`3oool0[@3oool00`000000oooo0?ooo`0V0?ooo`00
C03oool00`000000oooo0?ooo`280?ooo`030000003oool0oooo0:d0oooo00<000000?ooo`3oool0
9P3oool004`0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`2]0?ooo`030000003o
ool0oooo02H0oooo001<0?ooo`030000003oool0oooo08P0oooo0`00002]0?ooo`030000003oool0
oooo02H0oooo001<0?ooo`030000003oool0oooo08P0oooo00<000000?ooo`3oool0[@3oool00`00
0000oooo0?ooo`0V0?ooo`00C03oool00`000000oooo0?ooo`280?ooo`030000003oool0oooo0:h0
oooo00<000000?ooo`3oool09@3oool004/0oooo00<000000?ooo`3oool0R@3oool00`000000oooo
0?ooo`2^0?ooo`030000003oool0oooo02D0oooo001;0?ooo`030000003oool0oooo08T0oooo00<0
00000?ooo`3oool0[P3oool00`000000oooo0?ooo`0U0?ooo`00B`3oool00`000000oooo0?ooo`29
0?ooo`030000003oool0oooo0:h0oooo00<000000?ooo`3oool09@3oool004/0oooo00<000000?oo
o`3oool0R@3oool00`000000oooo0?ooo`2^0?ooo`030000003oool0oooo02D0oooo001;0?ooo`03
0000003oool0oooo08T0oooo00<000000?ooo`3oool0[P3oool00`000000oooo0?ooo`0U0?ooo`00
B`3oool00`000000oooo0?ooo`290?ooo`030000003oool0oooo0:h0oooo00<000000?ooo`3oool0
9@3oool004/0oooo00<000000?ooo`3oool0R@3oool00`000000oooo0?ooo`2^0?ooo`030000003o
ool0oooo02D0oooo001:0?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3oool0[P3oool0
0`000000oooo0?ooo`0U0?ooo`00BP3oool00`000000oooo0?ooo`2:0?ooo`<00000[`3oool00`00
0000oooo0?ooo`0T0?ooo`00BP3oool00`000000oooo0?ooo`2:0?ooo`030000003oool0oooo0:l0
oooo00<000000?ooo`3oool0903oool004X0oooo00<000000?ooo`3oool0RP3oool00`000000oooo
0?ooo`2_0?ooo`030000003oool0oooo02@0oooo001:0?ooo`030000003oool0oooo08X0oooo00<0
00000?ooo`3oool0[`3oool00`000000oooo0?ooo`0T0?ooo`00BP3oool00`000000oooo0?ooo`2:
0?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0903oool004X0oooo00<000000?oo
o`3oool0RP3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo02@0oooo00190?ooo`03
0000003oool0oooo08/0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0T0?ooo`00
B@3oool00`000000oooo0?ooo`1f0?ooo`050=BK0000000000000000001b^^X0103oool01@3oe9/0
0000000000000000VmCo00L0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0T0?oo
o`00B@3oool00`000000oooo0?ooo`1e0?ooo`070=BK0000Vm@0oooo0?ooo`3oom@0V`0007:jjP03
0?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo1P3oool00`000000oooo0?ooo`2`0?ooo`030000
003oool0oooo02<0oooo00190?ooo`030000003oool0oooo07X0oooo00H0omBK002Ke03oool0oooo
0?oDV`00Vm@30?ooo`030>ZjLP1b^^X0oooo00D0oooo00<000000?ooo`3oool0/03oool00`000000
oooo0?ooo`0S0?ooo`00B@3oool00`000000oooo0?ooo`1i0?ooo`030?oZ^P1b0780^^[o0080oooo
00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`050?ooo`@00000[`3oool00`000000oooo
0?ooo`0S0?ooo`00B@3oool00`000000oooo0?ooo`1g0?ooo`040>ZjLP000000001b0;[Zo`<0oooo
00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo0;00oooo
00<000000?ooo`3oool08`3oool004T0oooo00<000000?ooo`3oool0N@3oool00`3oj[X0LP1b0;[Z
o`020?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?oo
o`2`0?ooo`030000003oool0oooo02<0oooo00180?ooo`030000003oool0oooo07/0oooo00H0e9/0
09_Do`3oool0oooo0?oDV`1b^^X30?ooo`030>ZjLP1b^^X0oooo00D0oooo00<000000?ooo`3oool0
/03oool00`000000oooo0?ooo`0S0?ooo`00B03oool00`000000oooo0?ooo`1f0?ooo`070?oDV`00
0780^^[o0?ooo`3oj[X0LP1b0;[Zo`030?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo1P3oool0
0`000000oooo0?ooo`2`0?ooo`030000003oool0oooo02<0oooo00180?ooo`030000003oool0oooo
07L0oooo00D0onZj078000000000000009_Do`040?ooo`050?ooe02K000000000000LP2jj_l01`3o
ool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo02<0oooo00180?ooo`030000003oool0
oooo08`0oooo00<000000?ooo`3oool0/03oool00`000000oooo0?ooo`0S0?ooo`00B03oool00`00
0000oooo0?ooo`2<0?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool08P3oool004P0
oooo00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`2a0?ooo`030000003oool0oooo0280
oooo00180?ooo`030000003oool0oooo08`0oooo00<000000?ooo`3oool0/@3oool00`000000oooo
0?ooo`0R0?ooo`00A`3oool00`000000oooo0?ooo`2=0?ooo`030000003oool0oooo0;40oooo00<0
00000?ooo`3oool08P3oool004L0oooo00<000000?ooo`3oool0S@3oool300000;40oooo00<00000
0?ooo`3oool08P3oool004L0oooo00<000000?ooo`3oool0S@3oool00`000000oooo0?ooo`2a0?oo
o`030000003oool0oooo0280oooo00170?ooo`030000003oool0oooo08d0oooo00<000000?ooo`3o
ool0/@3oool00`000000oooo0?ooo`0R0?ooo`00A`3oool00`000000oooo0?ooo`2=0?ooo`030000
003oool0oooo0;40oooo00<000000?ooo`3oool08P3oool004L0oooo00<000000?ooo`3oool0S@3o
ool00`000000oooo0?ooo`2b0?ooo`030000003oool0oooo0240oooo00170?ooo`030000003oool0
oooo08d0oooo00<000000?ooo`3oool0/P3oool00`000000oooo0?ooo`0Q0?ooo`00AP3oool00`00
0000oooo0?ooo`2>0?ooo`030000003oool0oooo0;80oooo00<000000?ooo`3oool08@3oool004H0
oooo00<000000?ooo`3oool0SP3oool00`000000oooo0?ooo`2b0?ooo`030000003oool0oooo0240
oooo00160?ooo`030000003oool0oooo08h0oooo00<000000?ooo`3oool0/P3oool00`000000oooo
0?ooo`0Q0?ooo`00AP3oool00`000000oooo0?ooo`2>0?ooo`030000003oool0oooo0;80oooo00<0
00000?ooo`3oool08@3oool004H0oooo00<000000?ooo`3oool0SP3oool00`000000oooo0?ooo`2b
0?ooo`030000003oool0oooo0240oooo00160?ooo`030000003oool0oooo08h0oooo0`00002b0?oo
o`030000003oool0oooo0240oooo00160?ooo`030000003oool0oooo08h0oooo00<000000?ooo`3o
ool0/P3oool00`000000oooo0?ooo`0Q0?ooo`00AP3oool00`000000oooo0?ooo`2>0?ooo`030000
003oool0oooo0;80oooo00<000000?ooo`3oool08@3oool004H0oooo00<000000?ooo`3oool0SP3o
ool00`000000oooo0?ooo`2b0?ooo`030000003oool0oooo0240oooo00160?ooo`030000003oool0
oooo08h0oooo00<000000?ooo`3oool0/P3oool00`000000oooo0?ooo`0Q0?ooo`00\
\>"],
  ImageRangeCache->{{{91.1875, 378.188}, {517.313, 340.375}} -> {-6.88592, 
  79.9917, 0.0293408, 0.276478}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.301812 0.0122312 [
[.02381 .28931 -6 -9 ]
[.02381 .28931 6 0 ]
[.2619 .28931 -6 -9 ]
[.2619 .28931 6 0 ]
[.7381 .28931 -3 -9 ]
[.7381 .28931 3 0 ]
[.97619 .28931 -3 -9 ]
[.97619 .28931 3 0 ]
[.4875 .05719 -18 -4.5 ]
[.4875 .05719 0 4.5 ]
[.4875 .1795 -18 -4.5 ]
[.4875 .1795 0 4.5 ]
[.4875 .42412 -12 -4.5 ]
[.4875 .42412 0 4.5 ]
[.4875 .54644 -12 -4.5 ]
[.4875 .54644 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30181 m
.02381 .30806 L
s
[(-4)] .02381 .28931 0 1 Mshowa
.2619 .30181 m
.2619 .30806 L
s
[(-2)] .2619 .28931 0 1 Mshowa
.7381 .30181 m
.7381 .30806 L
s
[(2)] .7381 .28931 0 1 Mshowa
.97619 .30181 m
.97619 .30806 L
s
[(4)] .97619 .28931 0 1 Mshowa
.125 Mabswid
.08333 .30181 m
.08333 .30556 L
s
.14286 .30181 m
.14286 .30556 L
s
.20238 .30181 m
.20238 .30556 L
s
.32143 .30181 m
.32143 .30556 L
s
.38095 .30181 m
.38095 .30556 L
s
.44048 .30181 m
.44048 .30556 L
s
.55952 .30181 m
.55952 .30556 L
s
.61905 .30181 m
.61905 .30556 L
s
.67857 .30181 m
.67857 .30556 L
s
.79762 .30181 m
.79762 .30556 L
s
.85714 .30181 m
.85714 .30556 L
s
.91667 .30181 m
.91667 .30556 L
s
.25 Mabswid
0 .30181 m
1 .30181 L
s
.5 .05719 m
.50625 .05719 L
s
[(-20)] .4875 .05719 1 0 Mshowa
.5 .1795 m
.50625 .1795 L
s
[(-10)] .4875 .1795 1 0 Mshowa
.5 .42412 m
.50625 .42412 L
s
[(10)] .4875 .42412 1 0 Mshowa
.5 .54644 m
.50625 .54644 L
s
[(20)] .4875 .54644 1 0 Mshowa
.125 Mabswid
.5 .08165 m
.50375 .08165 L
s
.5 .10611 m
.50375 .10611 L
s
.5 .13058 m
.50375 .13058 L
s
.5 .15504 m
.50375 .15504 L
s
.5 .20396 m
.50375 .20396 L
s
.5 .22842 m
.50375 .22842 L
s
.5 .25289 m
.50375 .25289 L
s
.5 .27735 m
.50375 .27735 L
s
.5 .32627 m
.50375 .32627 L
s
.5 .35074 m
.50375 .35074 L
s
.5 .3752 m
.50375 .3752 L
s
.5 .39966 m
.50375 .39966 L
s
.5 .44859 m
.50375 .44859 L
s
.5 .47305 m
.50375 .47305 L
s
.5 .49751 m
.50375 .49751 L
s
.5 .52197 m
.50375 .52197 L
s
.5 .03273 m
.50375 .03273 L
s
.5 .00826 m
.50375 .00826 L
s
.5 .5709 m
.50375 .5709 L
s
.5 .59536 m
.50375 .59536 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .31812 m
.04262 .31859 L
.06244 .31919 L
.08255 .31994 L
.10458 .321 L
.12415 .32224 L
.14509 .32405 L
.1553 .3252 L
.16639 .32674 L
.17687 .32857 L
.18653 .33072 L
.1962 .33352 L
.20526 .33702 L
.2152 .34243 L
.22078 .34663 L
.22588 .35162 L
.23065 .35776 L
.23327 .362 L
.23573 .36677 L
.23803 .37213 L
.24052 .37922 L
.24277 .38721 L
.24487 .39657 L
.24737 .41127 L
.2487 .42132 L
.25012 .4346 L
.25161 .45246 L
.25302 .47491 L
.25429 .50214 L
.255 .52195 L
.25566 .54432 L
.25684 .59873 L
s
.25684 .59873 m
.25711 .61803 L
s
.26229 .61803 m
.26232 0 L
s
.26665 0 m
.26687 .01767 L
.26751 .05131 L
.26822 .0804 L
.26947 .11852 L
.27064 .14429 L
.27202 .16699 L
.27328 .18292 L
.27475 .19757 L
.27612 .20843 L
.27855 .22342 L
.28121 .23544 L
.28356 .24359 L
.28605 .25052 L
.29108 .26087 L
.29581 .2678 L
.30005 .27255 L
.30464 .27661 L
.31417 .28275 L
.31958 .28532 L
.32462 .2873 L
.3348 .29046 L
.34569 .29295 L
.35589 .29474 L
.36697 .29626 L
.37655 .29731 L
.38711 .29826 L
.40692 .29961 L
.41777 .30016 L
.42794 .30058 L
.4378 .30092 L
.44816 .3012 L
.45787 .30142 L
.46668 .30157 L
.47625 .30169 L
.48151 .30174 L
.48392 .30176 L
.48646 .30177 L
.48865 .30178 L
.49106 .30179 L
.49324 .3018 L
.49529 .30181 L
.49652 .30181 L
.4977 .30181 L
.49875 .30181 L
.4999 .30181 L
.50114 .30181 L
.50177 .30181 L
.50246 .30181 L
.50369 .30181 L
Mistroke
.50484 .30181 L
.50727 .3018 L
.50953 .30179 L
.51201 .30178 L
.51466 .30177 L
.52007 .30172 L
.525 .30168 L
.53451 .30155 L
.5435 .30139 L
.5532 .30117 L
.56349 .30088 L
.58193 .30017 L
.59135 .2997 L
.60148 .2991 L
.61979 .29767 L
.6299 .29663 L
.64094 .29521 L
.65136 .29352 L
.66103 .2915 L
.67161 .28859 L
.68157 .28481 L
.69051 .28005 L
.69555 .27646 L
.70018 .27232 L
.70488 .26691 L
.70747 .26322 L
.70993 .2591 L
.7122 .25457 L
.71468 .24863 L
.71902 .23453 L
.7215 .22316 L
.72423 .2059 L
.7256 .19437 L
.72708 .17872 L
.72848 .15953 L
.72976 .13629 L
.73096 .10701 L
.73207 .06933 L
.73329 .00787 L
Mfstroke
.73329 .00787 m
.73338 0 L
s
.73762 0 m
.73777 .61803 L
s
.74289 .61803 m
.7432 .59614 L
.74437 .5432 L
.74563 .50428 L
.74697 .47503 L
.74824 .45454 L
.74939 .43996 L
.75164 .41857 L
.75407 .40225 L
.75636 .39082 L
.75847 .38259 L
.76326 .369 L
.76598 .36337 L
.76851 .35904 L
.77363 .35217 L
.77911 .34673 L
.78442 .34269 L
.78932 .33971 L
.80041 .33471 L
.81018 .33159 L
.82054 .3291 L
.82995 .32733 L
.84007 .3258 L
.85837 .32371 L
.87949 .32198 L
.89958 .32078 L
.91937 .31986 L
.93776 .31918 L
.97619 .31812 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oL@3oool0
0`000000oooo0000001S0?ooo`030000003oool0oooo0640oooo00<000000?ooo`000000LP3oool0
0740oooo00<000000?ooo`000000H`3oool00`000000oooo0?ooo`1Q0?ooo`030000003oool00000
0780oooo001a0?ooo`030000003oool0000006<0oooo00<000000?ooo`3oool0H@3oool00`000000
oooo0000001b0?ooo`00L@3oool00`000000oooo0000001S0?ooo`<00000H@3oool00`000000oooo
0000001b0?ooo`00L@3oool00`000000oooo0000001S0?ooo`030000003oool0oooo0640oooo00<0
00000?ooo`000000LP3oool00740oooo00<000000?ooo`000000H`3oool00`000000oooo0?ooo`1Q
0?ooo`030000003oool000000780oooo001a0?ooo`030000003oool0000006<0oooo00<000000?oo
o`3oool0H@3oool00`000000oooo0000001b0?ooo`00L@3oool00`000000oooo0000001S0?ooo`03
0000003oool0oooo0640oooo00<000000?ooo`000000LP3oool00740oooo00<000000?ooo`000000
H`3oool00`000000oooo0?ooo`1Q0?ooo`030000003oool000000780oooo001a0?ooo`030000003o
ool0000006<0oooo00<000000?ooo`3oool0H@3oool00`000000oooo0000001b0?ooo`00L@3oool0
0`000000oooo0000001S0?ooo`030000003oool0oooo0640oooo00<000000?ooo`000000LP3oool0
0740oooo00<000000?ooo`000000H`3oool00`000000oooo0?ooo`1Q0?ooo`030000003oool00000
0780oooo001a0?ooo`030000003oool0000006<0oooo00<000000?ooo`3oool0H@3oool00`000000
oooo0000001b0?ooo`00L@3oool00`000000oooo0000001S0?ooo`030000003oool0oooo0640oooo
00<000000?ooo`000000LP3oool00740oooo00<000000?ooo`000000H`3oool300000640oooo00<0
00000?ooo`000000LP3oool00740oooo00<000000?ooo`000000H`3oool00`000000oooo0?ooo`1Q
0?ooo`030000003oool000000780oooo001a0?ooo`030000003oool0000006<0oooo00<000000?oo
o`3oool0H@3oool00`000000oooo0000001b0?ooo`00L@3oool00`000000oooo0000001S0?ooo`03
0000003oool0oooo0640oooo00<000000?ooo`000000LP3oool00740oooo00<000000?ooo`000000
H`3oool00`000000oooo0?ooo`1Q0?ooo`030000003oool000000780oooo001a0?ooo`030000003o
ool0000006<0oooo00<000000?ooo`3oool0H@3oool00`000000oooo0000001b0?ooo`00L@3oool0
0`000000oooo0000001S0?ooo`030000003oool0oooo0640oooo00<000000?ooo`000000LP3oool0
0740oooo00<000000?ooo`000000C03oool00`3oom@0V`00000000040000000509_Do`3oool0oooo
0?ooo`3oe9/00`0000000`2Ke?l0oooo0?ooo`050?ooo`030000003oool0oooo0640oooo00<00000
0?ooo`000000LP3oool00740oooo00<000000?ooo`000000C@3oool00`3DV`00002K0=Coo`020?oo
o`030>ZjV`2jj_l0oooo0080oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool60?ooo`030000003o
ool0oooo0640oooo00<000000?ooo`000000LP3oool00740oooo00<000000?ooo`000000CP3oool0
0`3oe9/0001b0;[Zo`050?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool01@3oool0
0`000000oooo0?ooo`1Q0?ooo`030000003oool000000780oooo001a0?ooo`030000003oool00000
04l0oooo00<0onZj0780001b^^X0103oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo
00D0oooo1000001P0?ooo`030000003oool000000780oooo001a0?ooo`030000003oool0000004@0
oooo00<0^W800000000000000`0000000`00L[X0oooo0?ooo`040?ooo`030;Yb001b^^X0oooo0080
oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo0640
oooo00<000000?ooo`000000LP3oool00740oooo00<000000?ooo`000000DP3oool01P2jLY/0e?oo
0?ooo`3oool0j[Yb07:jjP<0oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?ooo`1Q0?oo
o`030000003oool000000780oooo001a0?ooo`030000003oool0000004d0oooo00<0j[Yb09_Do`3o
ool00P3oool01P3DV`00VmCo0?ooo`3oool0omBK07:jjP<0oooo00<0j[Yb07:jjP3oool01@3oool0
0`000000oooo0?ooo`1Q0?ooo`030000003oool000000780oooo001a0?ooo`030000003oool00000
04d0oooo00L0omBK0000V`3Dool0oooo0?oDV`000780^^[o00<0oooo00H0^W8009_Do`3oool0onZj
0780V`3Dool60?ooo`030000003oool0oooo0640oooo00<000000?ooo`000000LP3oool00740oooo
00<000000?ooo`000000CP3oool01@3oe9/00000000000000780^^[o00@0oooo00D0oooD09/00000
0000001b0;[Zo`070?ooo`030000003oool0oooo0640oooo00<000000?ooo`000000LP3oool00740
oooo00<000000?ooo`000000H`3oool00`000000oooo0?ooo`1Q0?ooo`030000003oool000000780
oooo001a0?ooo`030000003oool0000006<0oooo00<000000?ooo`3oool0H@3oool00`000000oooo
0000001b0?ooo`00L@3oool00`000000oooo0000001S0?ooo`030000003oool0oooo0640oooo00<0
00000?ooo`000000LP3oool00740oooo00<000000?ooo`000000H`3oool00`000000oooo0?ooo`1Q
0?ooo`030000003oool000000780oooo001a0?ooo`030000003oool0000006<0oooo00<000000?oo
o`3oool0H@3oool00`000000oooo0000001b0?ooo`00L@3oool00`000000oooo0000001S0?ooo`<0
0000H@3oool00`000000oooo0000001b0?ooo`00L@3oool00`000000oooo0000001S0?ooo`030000
003oool0oooo0640oooo00<000000?ooo`000000LP3oool00740oooo00<000000?ooo`000000H`3o
ool00`000000oooo0?ooo`1Q0?ooo`030000003oool000000780oooo001a0?ooo`030000003oool0
000006<0oooo00<000000?ooo`3oool0H03oool010000000oooo0?ooo`00001b0?ooo`00L@3oool0
0`000000oooo0000001S0?ooo`030000003oool0oooo0600oooo00@000000?ooo`3oool00000LP3o
ool00740oooo00<000000?ooo`000000H`3oool00`000000oooo0?ooo`1P0?ooo`040000003oool0
oooo00000780oooo001a0?ooo`030000003oool0000006<0oooo00<000000?ooo`3oool0H03oool0
10000000oooo0?ooo`00001b0?ooo`00L@3oool00`000000oooo0000001S0?ooo`030000003oool0
oooo0600oooo00@000000?ooo`3oool00000LP3oool00740oooo00@000000?ooo`3oool00000HP3o
ool00`000000oooo0?ooo`1P0?ooo`040000003oool0oooo00000780oooo001a0?ooo`040000003o
ool0oooo00000680oooo00<000000?ooo`3oool0H03oool010000000oooo0?ooo`00001b0?ooo`00
L@3oool010000000oooo0?ooo`00001R0?ooo`<00000H03oool010000000oooo0?ooo`00001b0?oo
o`00L@3oool010000000oooo0?ooo`00001R0?ooo`030000003oool0oooo0600oooo00@000000?oo
o`3oool00000LP3oool00740oooo00@000000?ooo`3oool00000HP3oool00`000000oooo0?ooo`1P
0?ooo`040000003oool0oooo00000780oooo001a0?ooo`040000003oool0oooo00000680oooo00<0
00000?ooo`3oool0H03oool010000000oooo0?ooo`00001b0?ooo`00L@3oool010000000oooo0?oo
o`00001R0?ooo`030000003oool0oooo0600oooo00@000000?ooo`3oool00000LP3oool00740oooo
00@000000?ooo`3oool00000HP3oool00`000000oooo0?ooo`1P0?ooo`040000003oool0oooo0000
0780oooo001a0?ooo`040000003oool0oooo00000680oooo00<000000?ooo`3oool0H03oool01000
0000oooo0?ooo`00001b0?ooo`00L@3oool010000000oooo0?ooo`00001R0?ooo`030000003oool0
oooo0600oooo00@000000?ooo`3oool00000LP3oool00740oooo00@000000?ooo`3oool00000HP3o
ool00`000000oooo0?ooo`1P0?ooo`040000003oool0oooo00000780oooo001a0?ooo`040000003o
ool0oooo00000680oooo00<000000?ooo`3oool0H03oool010000000oooo0?ooo`00001b0?ooo`00
L@3oool010000000oooo0?ooo`00001R0?ooo`030000003oool0oooo0600oooo00@000000?ooo`3o
ool00000LP3oool00740oooo00@000000?ooo`3oool00000HP3oool300000600oooo00@000000?oo
o`3oool00000LP3oool00740oooo00@000000?ooo`3oool00000HP3oool00`000000oooo0?ooo`1P
0?ooo`040000003oool0oooo00000780oooo001a0?ooo`040000003oool0oooo00000680oooo00<0
00000?ooo`3oool0H03oool010000000oooo0?ooo`00001b0?ooo`00L@3oool010000000oooo0?oo
o`00001R0?ooo`030000003oool0oooo0600oooo00@000000?ooo`3oool00000LP3oool00740oooo
00@000000?ooo`3oool00000HP3oool00`000000oooo0?ooo`1P0?ooo`040000003oool0oooo0000
0780oooo001a0?ooo`040000003oool0oooo00000680oooo00<000000?ooo`3oool0H03oool01000
0000oooo0?ooo`00001b0?ooo`00L@3oool010000000oooo0?ooo`00001R0?ooo`030000003oool0
oooo0600oooo00@000000?ooo`3oool00000LP3oool00740oooo00@000000?ooo`3oool00000HP3o
ool00`000000oooo0?ooo`1O0?ooo`050000003oool0oooo0?ooo`000000LP3oool00740oooo00@0
00000?ooo`3oool00000HP3oool00`000000oooo0?ooo`1O0?ooo`050000003oool0oooo0?ooo`00
0000LP3oool00740oooo00@000000?ooo`3oool00000HP3oool00`000000oooo0?ooo`1O0?ooo`05
0000003oool0oooo0?ooo`000000LP3oool00740oooo00@000000?ooo`3oool00000HP3oool30000
05l0oooo00D000000?ooo`3oool0oooo0000001b0?ooo`00L@3oool01@000000oooo0?ooo`3oool0
00000640oooo00<000000?ooo`3oool0G`3oool01@000000oooo0?ooo`3oool000000780oooo001a
0?ooo`050000003oool0oooo0?ooo`000000H@3oool00`000000oooo0?ooo`1O0?ooo`050000003o
ool0oooo0?ooo`000000LP3oool00740oooo00D000000?ooo`3oool0oooo0000001Q0?ooo`030000
003oool0oooo05l0oooo00D000000?ooo`3oool0oooo0000001b0?ooo`00L@3oool01@000000oooo
0?ooo`3oool000000640oooo00<000000?ooo`3oool0G`3oool01@000000oooo0?ooo`3oool00000
0780oooo001a0?ooo`050000003oool0oooo0?ooo`000000H@3oool00`000000oooo0?ooo`1O0?oo
o`050000003oool0oooo0?ooo`000000LP3oool00740oooo00D000000?ooo`3oool0oooo0000001Q
0?ooo`030000003oool0oooo05l0oooo00D000000?ooo`3oool0oooo0000001b0?ooo`00L@3oool0
1@000000oooo0?ooo`3oool0000004/0oooo00<0omBK0000000000000`0000001@00Vm@0oooo0?oo
o`3oool0omBK00<0000000<0VmCo0?ooo`3oool01@3oool00`000000oooo0?ooo`1O0?ooo`050000
003oool0oooo0?ooo`000000LP3oool00740oooo00D000000?ooo`3oool0oooo0000001>0?ooo`03
0;YbLP2jj_l0oooo00@0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool60?ooo`030000003oool0
oooo05l0oooo00D000000?ooo`3oool0oooo0000001b0?ooo`00L@3oool01@000000oooo0?ooo`3o
ool0000004h0oooo00<0^W9b0;[Zo`3oool00`3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b
^^X0oooo00D0oooo00<000000?ooo`3oool0G`3oool01@000000oooo0?ooo`3oool000000780oooo
001a0?ooo`050000003oool0oooo0?ooo`000000CP3oool00`2jLW80^^[o0?ooo`030?ooo`030>Zj
LP1b^^X0oooo0080oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?ooo`1O0?ooo`050000
003oool0oooo0?ooo`000000LP3oool00740oooo00D000000?ooo`3oool0oooo000000120?ooo`03
0;Yb00000000000000<0000000<007:j0?ooo`3oool00`3oool00`2jLW80^^[o0?ooo`030?ooo`03
0>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool01@3oool4000005h0oooo00D000000?ooo`3o
ool0oooo0000001b0?ooo`00L@3oool01@000000oooo0?ooo`3oool0000004h0oooo00<0^W9b0;[Z
o`3oool00`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00D0oooo00<000000?oo
o`3oool0G`3oool01@000000oooo0?ooo`3oool000000780oooo001a0?ooo`050000003oool0oooo
0?ooo`000000CP3oool00`2jLW80^^[o0?ooo`030?ooo`030?oDV`1b^^X0oooo0080oooo00<0j[Yb
07:jjP3oool01@3oool00`000000oooo0?ooo`1O0?ooo`050000003oool0oooo0?ooo`000000LP3o
ool00740oooo00D000000?ooo`3oool0oooo0000001;0?ooo`050>ZjLP00000007:j0;YbLP2jj_l0
1@3oool01P2jLP00VmCo0?ooo`3oj[X0LP2K0=Coo`H0oooo00<000000?ooo`3oool0GP3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0700oooo001a0?ooo`050000003oool0oooo0?oo
o`000000C@3oool00`3Z^W80001b0;[Zo`050?ooo`050?ooe02K000000000000LP2jj_l01`3oool0
0`000000oooo0?ooo`1N0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0L03oool0
0740oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo
05h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1`0?ooo`00L@3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool0GP3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0700oooo001a0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0L03oool00740oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`1N0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`1`0?ooo`00L@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo05h0oooo00<00000
0?ooo`3oool0G@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0700oooo001a0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0GP3oool3000005d0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`1`0?ooo`00L@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo05d0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0700oooo001a0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
G@3oool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
L03oool00740oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1M0?ooo`030000003o
ool0oooo05d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1`0?ooo`00L@3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0G@3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0700oooo001a0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0L03oool00740oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`1L0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`1`0?ooo`00L@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo05`0oooo
00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0700oooo
001a0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?oo
o`1L0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0L03oool00740oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo05`0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`1`0?ooo`00L@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo05`0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0700oooo001a0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0G03oool3000005`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1`0?ooo`00
L@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0
F`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0700oooo001a0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`1K0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0L03oool00740oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`1K0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`1`0?ooo`00L@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
05/0oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0700oooo001a0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0FP3oool00`000000
oooo0?ooo`1J0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0L03oool00740oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05X0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1`0?ooo`00L@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0700oooo001a0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0F@3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0L03oool00740oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1I0?oo
o`030000003oool0oooo05T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1`0?oo
o`00L@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo05T0oooo0`00001H0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0L03oool00740oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo05P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`1`0?ooo`00L@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo05P0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo0700oooo001a0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0E`3oool0
0`000000oooo0?ooo`1G0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0L03oool0
00d0oooo00D0onZj078000000000000009_Do`1O0?ooo`030000002K0000000000@0000000<0VmCo
0?ooo`3oool00P3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo05H0oooo00<00000
0?ooo`3oool01P3oool00`3oom@0V`00000000040000000309_Do`3oool0oooo05l0oooo00D0onZj
078000000000000009_Do`090?ooo`003`3oool00`3DV`00VmCo0?ooo`1O0?ooo`040000003DV`00
002K0=Coo`80oooo00<0j[ZK0;[Zo`3oool0103oool00`000000oooo0?ooo`1F0?ooo`030000003o
ool0oooo05H0oooo00<000000?ooo`3oool01`3oool01`3DV`00002K0=Coo`000000oooo0>ZjV`2j
j_l0H`3oool00`3DV`00VmCo0?ooo`090?ooo`003`3oool00`3DV`00VmCo0?ooo`1O0?ooo`050000
003oool0omBK0000LP2jj_l0203oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo05D0
oooo00<000000?ooo`3oool02@3oool00`3oe9/0001b0000001V0?ooo`030=BK002Ke?l0oooo00T0
oooo000;0?ooo`030>ZjLP000000000000<0000000<0VmCo0?ooo`3oool0G@3oool01P000000oooo
0?ooo`3oj[X0LP0007:jjPP0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1D0?oo
o`030000003oool0oooo00/0oooo00<0onZj0000001b^^X0H@3oool00`3Z^W800000000000030000
000309_Do`3oool0oooo00L0oooo00020?ooo`030;Yb00000000000000<0000000T007:j0?ooo`3o
ool0omBK0000V`3Dool0oooo0=BK002Ke?l0F03oool00`2jLP0000000000000300000003001b^P3o
ool0000000@0oooo00<0^W8007:jjP3oool01`3oool00`000000oooo0?ooo`1D0?ooo`030000003o
ool0oooo05@0oooo00<000000?ooo`3oool0303oool00`000000^W8007:jjP1P0?ooo`060?oDV`00
09/0e?oo0?ooo`3DV`00VmCo2P3oool000`0oooo00D0j[Yb002Ke03oool0e9/009_Do`1P0?ooo`03
0000003oool0oooo00<0oooo00<0^W:K0=Coo`3oool01`3oool00`000000oooo0?ooo`1C0?ooo`03
0000003oool0oooo05<0oooo00<000000?ooo`3oool03@3oool010000000oooo0;YbV`3DoomP0?oo
o`050>ZjLP00Vm@0oooo0=BK002Ke?l02P3oool000d0oooo00@0^W8007:jjP3DV`00VmCoH03oool0
0`000000j[Yb09_Do`030?ooo`030=BK002Ke?l0oooo00P0oooo00<000000?ooo`3oool0DP3oool0
0`000000oooo0?ooo`1B0?ooo`030000003oool0oooo00/0oooo00L0j[Yb09_Do`3oool000000?oo
o`3DV`00VmCo0640oooo00@0^W8007:jjP3DV`00VmCo2P3oool000d0oooo00@0onZj0780LP1bLP00
VmCoH03oool020000000omBK0000V`3Dool0oooo0?oDV`000780^^[o2P3oool00`000000oooo0?oo
o`1A0?ooo`<00000D@3oool00`000000oooo0?ooo`0<0?ooo`070?oDV`0009/0e?oo0000003oe9/0
001b0;[Zo`1Q0?ooo`040?oZ^P1b0780LW8009_Do`X0oooo000>0?ooo`030?oDV`000000VmCo0600
oooo00<000000?ooo`3oe9/00P0000000`000780^^[o0?ooo`0;0?ooo`800000D@3oool00`000000
oooo0?ooo`1?0?ooo`800000403oool01@3oe9/00000000000000780^^[o06<0oooo00<0omBK0000
002Ke?l02P3oool00740oooo00<000000?ooo`3oool04P3oool2000004l0oooo00<000000?ooo`3o
ool0C@3oool2000001@0oooo00<000000?ooo`3oool0L03oool00740oooo00<000000?ooo`3oool0
503oool3000004`0oooo00<000000?ooo`3oool0B`3oool2000001H0oooo00<000000?ooo`3oool0
L03oool00740oooo00<000000?ooo`3oool05`3oool2000004X0oooo00<000000?ooo`3oool0B@3o
ool2000001P0oooo00<000000?ooo`3oool0L03oool00740oooo00<000000?ooo`3oool06@3oool2
000004P0oooo00<000000?ooo`3oool0A@3oool4000001X0oooo00<000000?ooo`3oool0L03oool0
0740oooo00<000000?ooo`3oool06`3oool4000004@0oooo00<000000?ooo`3oool0@@3oool40000
01h0oooo00<000000?ooo`3oool0L03oool00740oooo00<000000?ooo`3oool07`3oool9000003/0
oooo00<000000?ooo`3oool0?@3oool400000280oooo00<000000?ooo`3oool0L03oool00740oooo
00<000000?ooo`3oool0:03oool4000003L0oooo00<000000?ooo`3oool0=03oool9000002H0oooo
00<000000?ooo`3oool0L03oool00740oooo00<000000?ooo`3oool0;03oool;000002`0oooo00<0
00000?ooo`3oool09`3oool=000002l0oooo00<000000?ooo`3oool0L03oool00?l00000/0000001
0?ooo`002P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00T0oooo000:0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool0
I03oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0
I03oool00`000000oooo0?ooo`090?ooo`00L@3oool00`000000oooo0?ooo`1S0?ooo`030000003o
ool0oooo06<0oooo00<000000?ooo`3oool0L03oool00740oooo00<000000?ooo`3oool0H`3oool0
0`000000oooo0?ooo`1S0?ooo`030000003oool0oooo0700oooo001a0?ooo`030000003oool0oooo
06<0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1`0?ooo`002P3oool4000006<0
oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo05`0
oooo2@00000;0?ooo`003P3ooolJ000004T0oooo00<000000?ooo`3oool0H`3oool00`000000oooo
0?ooo`1S0?ooo`030000003oool0oooo04P0oooo5000000D0?ooo`00:03ooolB000003L0oooo00<0
00000?ooo`3oool0H`3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo03H0oooo4P00
000X0?ooo`00>P3oool700000300oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1S
0?ooo`030000003oool0oooo02h0oooo2000000j0?ooo`00@@3oool9000002L0oooo00<000000?oo
o`3oool0H`3oool3000006<0oooo00<000000?ooo`3oool0903oool:00000480oooo001:0?ooo`@0
00008`3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3o
ool07`3oool5000004`0oooo001>0?ooo`@000007`3oool00`000000oooo0?ooo`1S0?ooo`030000
003oool0oooo06<0oooo00<000000?ooo`3oool0703oool300000540oooo001B0?ooo`<00000703o
ool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool06P3o
ool2000005@0oooo001E0?ooo`8000006P3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0
oooo06<0oooo00<000000?ooo`3oool05`3oool3000005H0oooo001G0?ooo`800000603oool00`00
0000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool05@3oool20000
05T0oooo001I0?ooo`8000005P3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0
oooo00<000000?ooo`3oool04`3oool2000005/0oooo001K0?ooo`800000503oool00`000000oooo
0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool04@3oool2000005d0oooo
001M0?ooo`8000004P3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`1M0?ooo`00G`3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo05h0oooo001P0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0H`3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0G`3oool00640oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`1S0?ooo`<0
0000H`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0600oooo001R0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1S0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0H@3oool00680oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`1Q0?ooo`00H`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo06<0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo0680oooo001T0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0H`3oool00`00
0000oooo0?ooo`1S0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0H`3oool006@0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1T0?ooo`00I@3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0H`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo06D0oooo001U0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0H`3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0I@3oool006H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1S
0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1U
0?ooo`00IP3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo06<0oooo00<000000?oo
o`3oool0H`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06H0oooo001V0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0H`3oool3000006<0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`1V0?ooo`00I`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo06<0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo06H0oooo001W0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0H`3o
ool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0I`3o
ool006L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0
oooo06<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1W0?ooo`00J03oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0H`3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo06L0oooo001X0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0J03oool006P0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`1X0?ooo`00J03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo06<0oooo00<0
00000?ooo`3oool0H`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06P0oooo001Y
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1S
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0J03oool006T0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`1X0?ooo`00J@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo06<0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo06T0oooo001Y0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
H`3oool3000006<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1Y0?ooo`00J@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0H`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo06T0oooo001Z0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0J@3oool006X0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`1Y0?ooo`00JP3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo06<0
oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo06T0
oooo001Z0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0H`3oool00`000000oooo
0?ooo`1S0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0JP3oool006X0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`1Z0?ooo`00JP3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo04d0oooo00<0omBK0000000000000`0000001@00Vm@0oooo0?ooo`3o
ool0omBK00<0000000<0VmCo0?ooo`3oool01@3oool00`000000oooo0?ooo`1S0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0JP3oool006/0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`1@0?ooo`030;YbLP2jj_l0oooo00@0oooo00H0^W:K0=Coo`3oool0oooD09/0
V`3Dool60?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0500oooo00<0
^W9b0;[Zo`3oool00`3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00D0oooo00<0
00000?ooo`3oool0H`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo06X0oooo001[
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0D03oool00`2jLW80^^[o0?ooo`03
0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool01@3oool400000680oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0500oooo00<0^W9b0;[Zo`3oool00`3oool00`3Z^W80L[[Z0?ooo`020?oo
o`030?oDV`00Vm@0oooo00D0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo06X0oooo001[0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0D03oool00`2jLW80^^[o0?ooo`030?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03o
ool01@3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0JP3oool006`0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1@0?ooo`030;Yb
LP2jj_l0oooo00<0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`050?ooo`030000
003oool0oooo06<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1[0?ooo`00K03o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04d0oooo00D0j[Yb00000000L[X0^W9b
0;[Zo`050?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo1P3oool00`000000oooo0?ooo`1S0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0J`3oool006`0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`1?0?ooo`030>ZjLP000780^^[o00D0oooo00D0oooD09/00000
0000001b0;[Zo`070?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`1[0?ooo`00K03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo06<0
oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo06/0
oooo001/0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0H`3oool00`000000oooo
0?ooo`1S0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0J`3oool006`0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`1[0?ooo`00K03oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo06/0oooo001/0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0H`3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0J`3oool006`0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1S0?ooo`<0
0000H`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo06/0oooo001/0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1S0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0J`3oool006`0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`1[0?ooo`00K03oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo06<0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo06/0oooo001/0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0H`3oool00`00
0000oooo0?ooo`1S0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0J`3oool006`0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1[0?ooo`00K03oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0H`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo06/0oooo001]0?ooo`050000003oool0oooo0?ooo`000000
I@3oool00`000000oooo0?ooo`1S0?ooo`050000003oool0oooo0?ooo`000000KP3oool006d0oooo
00D000000?ooo`3oool0oooo0000001U0?ooo`030000003oool0oooo06<0oooo00D000000?ooo`3o
ool0oooo0000001^0?ooo`00K@3oool01@000000oooo0?ooo`3oool0000006D0oooo00<000000?oo
o`3oool0H`3oool01@000000oooo0?ooo`3oool0000006h0oooo001]0?ooo`050000003oool0oooo
0?ooo`000000I@3oool3000006<0oooo00D000000?ooo`3oool0oooo0000001^0?ooo`00K@3oool0
1@000000oooo0?ooo`3oool0000006D0oooo00<000000?ooo`3oool0H`3oool01@000000oooo0?oo
o`3oool0000006h0oooo001]0?ooo`050000003oool0oooo0?ooo`000000I@3oool00`000000oooo
0?ooo`1S0?ooo`050000003oool0oooo0?ooo`000000KP3oool006d0oooo00D000000?ooo`3oool0
oooo0000001U0?ooo`030000003oool0oooo06<0oooo00D000000?ooo`3oool0oooo0000001^0?oo
o`00K@3oool01@000000oooo0?ooo`3oool0000006D0oooo00<000000?ooo`3oool0H`3oool01@00
0000oooo0?ooo`3oool0000006h0oooo001]0?ooo`050000003oool0oooo0?ooo`000000I@3oool0
0`000000oooo0?ooo`1S0?ooo`050000003oool0oooo0?ooo`000000KP3oool006d0oooo00D00000
0?ooo`3oool0oooo0000001U0?ooo`030000003oool0oooo06<0oooo00D000000?ooo`3oool0oooo
0000001^0?ooo`00K@3oool01@000000oooo0?ooo`3oool0000006D0oooo00<000000?ooo`3oool0
H`3oool01@000000oooo0?ooo`3oool0000006h0oooo001]0?ooo`050000003oool0oooo0?ooo`00
0000I@3oool00`000000oooo0?ooo`1S0?ooo`050000003oool0oooo0?ooo`000000KP3oool006d0
oooo00D000000?ooo`3oool0oooo0000001U0?ooo`030000003oool0oooo06<0oooo00D000000?oo
o`3oool0oooo0000001^0?ooo`00K@3oool01@000000oooo0?ooo`3oool0000006D0oooo00<00000
0?ooo`3oool0H`3oool01@000000oooo0?ooo`3oool0000006h0oooo001]0?ooo`050000003oool0
oooo0?ooo`000000I@3oool3000006<0oooo00D000000?ooo`3oool0oooo0000001^0?ooo`00K@3o
ool01@000000oooo0?ooo`3oool0000006D0oooo00<000000?ooo`3oool0H`3oool01@000000oooo
0?ooo`3oool0000006h0oooo001]0?ooo`050000003oool0oooo0?ooo`000000I@3oool00`000000
oooo0?ooo`1S0?ooo`050000003oool0oooo0?ooo`000000KP3oool006d0oooo00D000000?ooo`3o
ool0oooo0000001U0?ooo`030000003oool0oooo06<0oooo00D000000?ooo`3oool0oooo0000001^
0?ooo`00K@3oool01@000000oooo0?ooo`3oool0000006D0oooo00<000000?ooo`3oool0H`3oool0
1@000000oooo0?ooo`3oool0000006h0oooo001]0?ooo`050000003oool0oooo0?ooo`000000I@3o
ool00`000000oooo0?ooo`1S0?ooo`050000003oool0oooo0?ooo`000000KP3oool006d0oooo00D0
00000?ooo`3oool0oooo0000001U0?ooo`030000003oool0oooo06<0oooo00D000000?ooo`3oool0
oooo0000001^0?ooo`00KP3oool010000000oooo0?ooo`00001U0?ooo`030000003oool0oooo06<0
oooo00D000000?ooo`3oool0oooo0000001^0?ooo`00KP3oool010000000oooo0?ooo`00001U0?oo
o`030000003oool0oooo06<0oooo00D000000?ooo`3oool0oooo0000001^0?ooo`00KP3oool01000
0000oooo0?ooo`00001U0?ooo`030000003oool0oooo06<0oooo00D000000?ooo`3oool0oooo0000
001^0?ooo`00KP3oool010000000oooo0?ooo`00001U0?ooo`<00000H`3oool01@000000oooo0?oo
o`3oool0000006h0oooo001^0?ooo`040000003oool0oooo000006D0oooo00<000000?ooo`3oool0
H`3oool010000000oooo0?ooo`00001_0?ooo`00KP3oool010000000oooo0?ooo`00001U0?ooo`03
0000003oool0oooo06<0oooo00@000000?ooo`3oool00000K`3oool006h0oooo00@000000?ooo`3o
ool00000I@3oool00`000000oooo0?ooo`1S0?ooo`040000003oool0oooo000006l0oooo001^0?oo
o`040000003oool0oooo000006D0oooo00<000000?ooo`3oool0H`3oool010000000oooo0?ooo`00
001_0?ooo`00KP3oool010000000oooo0?ooo`00001U0?ooo`030000003oool0oooo06<0oooo00@0
00000?ooo`3oool00000K`3oool006h0oooo00@000000?ooo`3oool00000I@3oool00`000000oooo
0?ooo`1S0?ooo`040000003oool0oooo000006l0oooo001^0?ooo`040000003oool0oooo000004h0
oooo00<0oooD09/000000000100000001@2Ke?l0oooo0?ooo`3oool0omBK00<0000000<0VmCo0?oo
o`3oool01@3oool00`000000oooo0?ooo`1S0?ooo`040000003oool0oooo000006l0oooo001^0?oo
o`040000003oool0oooo000004l0oooo00<0e9/00000V`3Dool00P3oool00`3Z^Y/0^^[o0?ooo`02
0?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo1P3oool00`000000oooo0?ooo`1S0?ooo`040000
003oool0oooo000006l0oooo001^0?ooo`040000003oool0oooo00000500oooo00<0omBK0000LP2j
j_l01@3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00D0oooo00<000000?ooo`3o
ool0H`3oool010000000oooo0?ooo`00001_0?ooo`00KP3oool010000000oooo0?ooo`00001A0?oo
o`030?oZ^P1b0000L[[Z00@0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`050?oo
o`030000003oool0oooo06<0oooo00@000000?ooo`3oool00000K`3oool006h0oooo00@000000?oo
o`3oool00000D`3oool00`2jLP00L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK
002Ke03oool01@3oool400000680oooo00@000000?ooo`3oool00000K`3oool006h0oooo00@00000
0?ooo`3oool00000E03oool01P2jLY/0e?oo0?ooo`3oool0j[Yb07:jjP<0oooo00<0omBK002Ke03o
ool01@3oool00`000000oooo0?ooo`1S0?ooo`040000003oool0oooo000006l0oooo001^0?ooo`04
0000003oool0oooo000004l0oooo00<0j[Yb09_Do`3oool00P3oool01P3DV`00VmCo0?ooo`3oool0
omBK07:jjP<0oooo00<0j[Yb07:jjP3oool01@3oool00`000000oooo0?ooo`1S0?ooo`040000003o
ool0oooo000006l0oooo001^0?ooo`040000003oool0oooo000004l0oooo00L0omBK0000V`3Dool0
oooo0?oDV`000780^^[o00<0oooo00H0^W8009_Do`3oool0onZj0780V`3Dool60?ooo`030000003o
ool0oooo06<0oooo00@000000?ooo`3oool00000K`3oool006h0oooo00@000000?ooo`3oool00000
D03oool01@3oe9/00000000000000780^^[o00@0oooo00D0oooD09/000000000001b0;[Zo`070?oo
o`030000003oool0oooo06<0oooo00@000000?ooo`3oool00000K`3oool006h0oooo00@000000?oo
o`3oool00000I@3oool00`000000oooo0?ooo`1S0?ooo`040000003oool0oooo000006l0oooo001^
0?ooo`040000003oool0oooo000006D0oooo00<000000?ooo`3oool0H`3oool010000000oooo0?oo
o`00001_0?ooo`00KP3oool010000000oooo0?ooo`00001U0?ooo`030000003oool0oooo06<0oooo
00@000000?ooo`3oool00000K`3oool006h0oooo00@000000?ooo`3oool00000I@3oool00`000000
oooo0?ooo`1S0?ooo`040000003oool0oooo000006l0oooo001^0?ooo`040000003oool0oooo0000
06D0oooo00<000000?ooo`3oool0H`3oool010000000oooo0?ooo`00001_0?ooo`00KP3oool01000
0000oooo0?ooo`00001U0?ooo`<00000H`3oool010000000oooo0?ooo`00001_0?ooo`00KP3oool0
10000000oooo0?ooo`00001U0?ooo`030000003oool0oooo06<0oooo00@000000?ooo`3oool00000
K`3oool006h0oooo00@000000?ooo`3oool00000I@3oool00`000000oooo0?ooo`1S0?ooo`040000
003oool0oooo000006l0oooo001^0?ooo`040000003oool0oooo000006D0oooo00<000000?ooo`3o
ool0H`3oool010000000oooo0?ooo`00001_0?ooo`00KP3oool010000000oooo0?ooo`00001U0?oo
o`030000003oool0oooo06<0oooo00@000000?ooo`3oool00000K`3oool006h0oooo00@000000?oo
o`3oool00000I@3oool00`000000oooo0?ooo`1S0?ooo`040000003oool0oooo000006l0oooo001^
0?ooo`040000003oool0oooo000006D0oooo00<000000?ooo`3oool0H`3oool010000000oooo0?oo
o`00001_0?ooo`00KP3oool010000000oooo0?ooo`00001U0?ooo`030000003oool0oooo06<0oooo
00@000000?ooo`3oool00000K`3oool006h0oooo00@000000?ooo`3oool00000I@3oool00`000000
oooo0?ooo`1S0?ooo`040000003oool0oooo000006l0oooo001^0?ooo`040000003oool0oooo0000
06D0oooo00<000000?ooo`3oool0H`3oool010000000oooo0?ooo`00001_0?ooo`00KP3oool01000
0000oooo0?ooo`00001U0?ooo`030000003oool0oooo06<0oooo00@000000?ooo`3oool00000K`3o
ool006h0oooo00@000000?ooo`3oool00000I@3oool3000006<0oooo00@000000?ooo`3oool00000
K`3oool006h0oooo00@000000?ooo`3oool00000I@3oool00`000000oooo0?ooo`1S0?ooo`040000
003oool0oooo000006l0oooo001^0?ooo`040000003oool0oooo000006D0oooo00<000000?ooo`3o
ool0H`3oool010000000oooo0?ooo`00001_0?ooo`00KP3oool010000000oooo0?ooo`00001U0?oo
o`030000003oool0oooo06<0oooo00@000000?ooo`3oool00000K`3oool006h0oooo00@000000?oo
o`3oool00000I@3oool00`000000oooo0?ooo`1S0?ooo`040000003oool0oooo000006l0oooo001^
0?ooo`040000003oool0oooo000006D0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0000
001`0?ooo`00K`3oool00`000000oooo0000001U0?ooo`030000003oool0oooo06<0oooo00<00000
0?ooo`000000L03oool006l0oooo00<000000?ooo`000000I@3oool00`000000oooo0?ooo`1S0?oo
o`030000003oool000000700oooo001_0?ooo`030000003oool0000006D0oooo00<000000?ooo`3o
ool0H`3oool00`000000oooo0000001`0?ooo`00K`3oool00`000000oooo0000001U0?ooo`030000
003oool0oooo06<0oooo00<000000?ooo`000000L03oool00001\
\>"],
  ImageRangeCache->{{{91.1875, 378.188}, {703.25, 526.313}} -> {-6.88592, 
  125.628, 0.0293408, 0.285578}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.0147151 0.0490503 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.7381 .00222 -3 -9 ]
[.7381 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.4875 .11282 -6 -4.5 ]
[.4875 .11282 0 4.5 ]
[.4875 .21092 -6 -4.5 ]
[.4875 .21092 0 4.5 ]
[.4875 .30902 -6 -4.5 ]
[.4875 .30902 0 4.5 ]
[.4875 .40712 -6 -4.5 ]
[.4875 .40712 0 4.5 ]
[.4875 .50522 -12 -4.5 ]
[.4875 .50522 0 4.5 ]
[.4875 .60332 -12 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-4)] .02381 .00222 0 1 Mshowa
.2619 .01472 m
.2619 .02097 L
s
[(-2)] .2619 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(2)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(4)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.08333 .01472 m
.08333 .01847 L
s
.14286 .01472 m
.14286 .01847 L
s
.20238 .01472 m
.20238 .01847 L
s
.32143 .01472 m
.32143 .01847 L
s
.38095 .01472 m
.38095 .01847 L
s
.44048 .01472 m
.44048 .01847 L
s
.55952 .01472 m
.55952 .01847 L
s
.61905 .01472 m
.61905 .01847 L
s
.67857 .01472 m
.67857 .01847 L
s
.79762 .01472 m
.79762 .01847 L
s
.85714 .01472 m
.85714 .01847 L
s
.91667 .01472 m
.91667 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .11282 m
.50625 .11282 L
s
[(2)] .4875 .11282 1 0 Mshowa
.5 .21092 m
.50625 .21092 L
s
[(4)] .4875 .21092 1 0 Mshowa
.5 .30902 m
.50625 .30902 L
s
[(6)] .4875 .30902 1 0 Mshowa
.5 .40712 m
.50625 .40712 L
s
[(8)] .4875 .40712 1 0 Mshowa
.5 .50522 m
.50625 .50522 L
s
[(10)] .4875 .50522 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(12)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .03924 m
.50375 .03924 L
s
.5 .06377 m
.50375 .06377 L
s
.5 .08829 m
.50375 .08829 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .16187 m
.50375 .16187 L
s
.5 .18639 m
.50375 .18639 L
s
.5 .23544 m
.50375 .23544 L
s
.5 .25997 m
.50375 .25997 L
s
.5 .28449 m
.50375 .28449 L
s
.5 .33354 m
.50375 .33354 L
s
.5 .35807 m
.50375 .35807 L
s
.5 .38259 m
.50375 .38259 L
s
.5 .43164 m
.50375 .43164 L
s
.5 .45617 m
.50375 .45617 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52974 m
.50375 .52974 L
s
.5 .55427 m
.50375 .55427 L
s
.5 .57879 m
.50375 .57879 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .48114 L
.10458 .35966 L
.14415 .25677 L
.18221 .16805 L
.22272 .08462 L
.24141 .04994 L
.25127 .03264 L
.25666 .02346 L
.2593 .01904 L
.26045 .01712 L
.26171 .01504 L
.26301 .01654 L
.26425 .01856 L
.26698 .02299 L
.27279 .03224 L
.28302 .04796 L
.30316 .07681 L
.3438 .12647 L
.38293 .16348 L
.40291 .17829 L
.42451 .19119 L
.43466 .19614 L
.44538 .20059 L
.45542 .20404 L
.46458 .20657 L
.47406 .20859 L
.47927 .20943 L
.48422 .21005 L
.48643 .21028 L
.48878 .21048 L
.49081 .21062 L
.493 .21075 L
.49422 .2108 L
.49534 .21084 L
.49641 .21087 L
.49754 .2109 L
.49878 .21091 L
.49993 .21092 L
.5012 .21091 L
.50191 .2109 L
.50255 .21089 L
.50374 .21087 L
.50486 .21083 L
.50608 .21079 L
.5074 .21073 L
.51008 .21056 L
.51253 .21037 L
.51725 .20989 L
.52174 .20928 L
Mistroke
.53169 .20744 L
.54253 .20466 L
.56224 .19751 L
.58323 .18694 L
.60468 .17299 L
.62486 .15696 L
.66347 .11843 L
.70452 .06614 L
.71441 .05182 L
.72499 .03573 L
.73012 .02765 L
.73264 .0236 L
.73497 .01983 L
.73709 .01638 L
.73815 .01481 L
.73933 .01675 L
.74406 .02467 L
.78209 .09392 L
.82234 .17813 L
.86108 .26976 L
.90227 .37859 L
.94195 .49451 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3ooona
0?ooo`005`3oool01@3oj[X0LP00000000000000VmCo05X0oooo00<0oooD09/00000000010000000
0`2Ke?l0oooo0?ooo`2d0?ooo`030?ooe02K0000000000@0000000<0VmCo0?ooo`3oool0FP3oool0
1@3oj[X0LP00000000000000VmCo01<0oooo000I0?ooo`030=BK002Ke?l0oooo05/0oooo00<0e9/0
0000V`3Dool00P3oool00`3Z^Y/0^^[o0?ooo`2f0?ooo`030=BK000009/0e?oo0080oooo00<0j[ZK
0;[Zo`3oool0G@3oool00`3DV`00VmCo0?ooo`0C0?ooo`006@3oool00`3DV`00VmCo0?ooo`1L0?oo
o`030?oDV`000780^^[o0;/0oooo00<0omBK0000LP2jj_l0H@3oool00`3DV`00VmCo0?ooo`0C0?oo
o`005@3oool00`3Z^W800000000000030000000309_Do`3oool0oooo05/0oooo00<0onZj0780001b
^^X0^`3oool00`3oj[X0LP0007:jjP1L0?ooo`030>ZjLP000000000000<0000000<0VmCo0?ooo`3o
ool04@3oool000`0oooo00<0^W800000000000000`0000002@00L[X0oooo0?ooo`3oe9/0002K0=Co
o`3oool0e9/009_Do`1C0?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool0103oool0
0`2jLP00L[[Z0?ooo`2k0?ooo`030;Yb001b^^X0oooo05X0oooo00H0omBK0000V`3Dool0oooo0=BK
002Ke?lD0?ooo`005P3oool01@3Z^W8009_D0?ooo`3DV`00VmCo0640oooo00<0^W:K0=Coo`3oool0
^`3oool00`2jLY/0e?oo0?ooo`1J0?ooo`050>ZjLP00Vm@0oooo0=BK002Ke?l0503oool001L0oooo
00@0^W8007:jjP3DV`00VmCoG03oool00`3Z^W80VmCo0?ooo`020?ooo`030=BK002Ke?l0oooo0;H0
oooo00<0j[Yb09_Do`3oool00P3oool00`3DV`00VmCo0?ooo`1K0?ooo`040;Yb001b^^X0e9/009_D
oa@0oooo000G0?ooo`040?oZ^P1b0780LW8009_Doe`0oooo00L0omBK0000V`3Dool0oooo0?oDV`00
0780^^[o0;L0oooo00L0omBK0000V`3Dool0oooo0?oDV`000780^^[o05`0oooo00@0onZj0780LP1b
LP00VmCo503oool001P0oooo00<0omBK0000002Ke?l0G@3oool01@3oe9/00000000000000780^^[o
0;T0oooo00D0omBK000000000000001b0;[Zo`1N0?ooo`030?oDV`000000VmCo01@0oooo003o0?oo
ok40oooo003o0?oook40oooo003G0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`030000003o
ool0oooo0=H0oooo003G0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`030000003oool0oooo
0=H0oooo003G0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`030000003oool0oooo0=H0oooo
000;0?ooool00000VP00000<0?ooo`00503oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0E0?ooo`8000005`3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0E0?ooo`8000005`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0C0?ooo`00503oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`0E0?ooo`<000005P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
01H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
01H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0D0?ooo`80000000<0oooo0000
003oool05@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`3oool05P3oool00`000000oooo0?ooo`0C0?ooo`00503oool00`000000oooo0?ooo`1M0?ooo`04
0000003oool00000000005l0oooo00<000000?ooo`3oool0G03oool01@000000oooo0000003oool0
000005l0oooo00<000000?ooo`3oool04`3oool007@0oooo00D000000?ooo`3oool0oooo0000001N
0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1b
0?ooo`00L`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo05/0oooo00<000000?oo
o`3oool0F`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0740oooo001b0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`1K0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0L@3oool00780oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`1`0?ooo`00L@3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo05T0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo0700oooo001`0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0F@3oool0
0`000000oooo0?ooo`1I0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0K`3oool0
0700oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1H0?ooo`<00000F03oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo06l0oooo001_0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0KP3oool006l0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`1G0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`1^0?ooo`00KP3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo05L0oooo00<0
00000?ooo`3oool0EP3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo06d0oooo001^
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1F
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0K@3oool006d0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`1/0?ooo`00K03oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo05D0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo06`0oooo001/0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
E03oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
J`3oool006/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`1C0?ooo`030000003o
ool0oooo05<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`1[0?ooo`00J`3oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0DP3oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo06X0oooo001Z0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0DP3oool300000580oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`1Z0?ooo`00JP3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0540
oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo06T0
oooo001Y0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0D03oool00`000000oooo
0?ooo`1@0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0J@3oool006T0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo04l0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`1X0?ooo`00J03oool00`000000oooo0?ooo`0J
0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo06P0oooo001X0?ooo`030000003oool0oooo01/0oooo00<000000?oo
o`3oool0CP3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo01/0oooo00<000000?oo
o`3oool0I`3oool006L0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`1=0?ooo`03
0000003oool0oooo04d0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`1W0?ooo`00
I`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0
C03oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo06H0oooo001V0?ooo`030000003o
ool0oooo0200oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`1<0?ooo`030000003o
ool0oooo01h0oooo00<000000?ooo`3oool0IP3oool006H0oooo00<000000?ooo`3oool0803oool0
0`000000oooo0?ooo`1;0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool0803oool0
0`000000oooo0?ooo`1U0?ooo`00I@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo
04X0oooo0`00001:0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0I@3oool006D0
oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo04T0
oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`1T0?ooo`00I03oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo06@0oooo001T0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool0A`3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool0H`3oool006<0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`17
0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`1S
0?ooo`00H`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo04H0oooo00<000000?oo
o`3oool0AP3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0680oooo001R0?ooo`03
0000003oool0oooo02X0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`150?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool0HP3oool00680oooo00<000000?ooo`3oool0
:`3oool00`000000oooo0?ooo`0f0?ooo`030?ooe02K0000000000@0000000<0VmCo0?ooo`3oool0
103oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0
H@3oool00640oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0f0?ooo`030=BK0000
09/0e?oo0080oooo00<0j[ZK0;[Zo`3oool01@3oool00`000000oooo0?ooo`140?ooo`030000003o
ool0oooo02/0oooo00<000000?ooo`3oool0H@3oool00640oooo00<000000?ooo`3oool0;@3oool0
0`000000oooo0?ooo`0g0?ooo`030?oDV`000780^^[o00T0oooo00<000000?ooo`3oool0@`3oool0
0`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0600oooo001P0?ooo`030000003oool0oooo
02l0oooo00<000000?ooo`3oool0=`3oool00`3oj[X0LP0007:jjP080?ooo`@00000@@3oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0oooo0600oooo001P0?ooo`030000003oool0oooo0300
oooo00<000000?ooo`3oool0>03oool00`2jLP00L[[Z0?ooo`060?ooo`030000003oool0oooo0480
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`1O0?ooo`00G`3oool00`000000oooo
0?ooo`0b0?ooo`030000003oool0oooo03P0oooo00<0^W:K0=Coo`3oool01@3oool00`000000oooo
0?ooo`110?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0G`3oool005l0oooo00<0
00000?ooo`3oool0<`3oool00`000000oooo0?ooo`0b0?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0
e9/009_Do`3oool01@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0380oooo00<0
00000?ooo`3oool0GP3oool005h0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0b
0?ooo`070?oDV`0009/0e?oo0?ooo`3oe9/0001b0;[Zo`060?ooo`030000003oool0oooo03l0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`1N0?ooo`00GP3oool00`000000oooo0?oo
o`0e0?ooo`030000003oool0oooo0380oooo00D0omBK000000000000001b0;[Zo`070?ooo`030000
003oool0oooo03h0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`1M0?ooo`00G@3o
ool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0?@3o
ool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo05d0oooo001M0?ooo`030000003oool0
oooo03P0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0l0?ooo`030000003oool0
oooo03P0oooo00<000000?ooo`3oool0G03oool005`0oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`0k0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0>@3oool00`00
0000oooo0?ooo`1L0?ooo`00G03oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo03X0
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo05/0
oooo001K0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0>@3oool3000003T0oooo
00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`1K0?ooo`00F`3oool00`000000oooo0?oo
o`0n0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0=`3oool200000400oooo00<0
00000?ooo`3oool0FP3oool005X0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0g
0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`1J
0?ooo`00FP3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo03H0oooo00<000000?oo
o`3oool0=@3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo05T0oooo001I0?ooo`03
0000003oool0oooo04<0oooo0P00000f0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3o
ool0@`3oool00`000000oooo0?ooo`1I0?ooo`00F@3oool00`000000oooo0?ooo`150?ooo`030000
003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`150?ooo`030000
003oool0oooo05P0oooo001H0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0<P3o
ool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0F03o
ool005P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0a0?ooo`030000003oool0
oooo0340oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`1G0?ooo`00E`3oool00`00
0000oooo0?ooo`1:0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0<03oool00`00
0000oooo0?ooo`190?ooo`030000003oool0oooo05L0oooo001G0?ooo`030000003oool0oooo04/0
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo04/0
oooo00<000000?ooo`3oool0EP3oool005H0oooo00<000000?ooo`3oool0C@3oool00`000000oooo
0?ooo`0^0?ooo`<00000;P3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo05H0oooo
001F0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?oo
o`0]0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool0E@3oool005D0oooo00<00000
0?ooo`3oool0D03oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo02/0oooo0P00001A
0?ooo`030000003oool0oooo05D0oooo001E0?ooo`030000003oool0oooo0540oooo0P00000/0?oo
o`030000003oool0oooo02X0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`1D0?oo
o`00E@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3o
ool0:@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo05@0oooo001D0?ooo`030000
003oool0oooo05D0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0X0?ooo`030000
003oool0oooo05D0oooo00<000000?ooo`3oool0D`3oool005@0oooo00<000000?ooo`3oool0EP3o
ool2000002P0oooo00<000000?ooo`3oool09P3oool2000005P0oooo00<000000?ooo`3oool0D`3o
ool005<0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`1B0?ooo`00D`3oool00`00
0000oooo0?ooo`1J0?ooo`8000009@3oool00`000000oooo0?ooo`0S0?ooo`800000G03oool00`00
0000oooo0?ooo`1B0?ooo`00DP3oool00`000000oooo0?ooo`1M0?ooo`8000008`3oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0D@3oool00580oooo
00<000000?ooo`3oool0G`3oool200000240oooo0`00000P0?ooo`800000H03oool00`000000oooo
0?ooo`1A0?ooo`00DP3oool00`000000oooo0?ooo`1Q0?ooo`8000007`3oool00`000000oooo0?oo
o`0N0?ooo`800000H`3oool00`000000oooo0?ooo`1@0?ooo`00D@3oool00`000000oooo0?ooo`1T
0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0703oool2000006D0oooo00<00000
0?ooo`3oool0D03oool00540oooo00<000000?ooo`3oool0I@3oool2000001`0oooo00<000000?oo
o`3oool06P3oool2000006P0oooo00<000000?ooo`3oool0C`3oool00500oooo00<000000?ooo`3o
ool0J03oool3000001T0oooo00<000000?ooo`3oool0603oool2000006X0oooo00<000000?ooo`3o
ool0C`3oool00500oooo00<000000?ooo`3oool0J`3oool2000001L0oooo00<000000?ooo`3oool0
5@3oool3000006`0oooo00<000000?ooo`3oool0C`3oool00500oooo00<000000?ooo`3oool0K@3o
ool2000001D0oooo00<000000?ooo`3oool04`3oool200000700oooo00<000000?ooo`3oool0CP3o
ool004l0oooo00<000000?ooo`3oool0L03oool2000000P0oooo00D0onZj078000000000000009_D
o`060?ooo`030000003oool0oooo0100oooo0`00001b0?ooo`030000003oool0oooo04h0oooo001?
0?ooo`030000003oool0oooo0780oooo0`0000070?ooo`030=BK002Ke?l0oooo00H0oooo00<00000
0?ooo`3oool03@3oool3000007H0oooo00<000000?ooo`3oool0C@3oool004h0oooo00<000000?oo
o`3oool0MP3oool7000000030=BK002Ke?l0oooo00H0oooo00<000000?ooo`3oool02@3oool40000
07T0oooo00<000000?ooo`3oool0C@3oool004h0oooo00<000000?ooo`3oool0N@3oool00`3Z^W80
00000000000F000007h0oooo00<000000?ooo`3oool0C03oool004d0oooo00<000000?ooo`3oool0
NP3oool01P3oe9/0002K0=Coo`3oool0e9/009_Do`L0oooo00<000000?ooo`3oool0Q`3oool00`00
0000oooo0?ooo`1<0?ooo`00C@3oool00`000000oooo0?ooo`1k0?ooo`050>ZjLP00Vm@0oooo0=BK
002Ke?l01`3oool00`000000oooo0?ooo`270?ooo`030000003oool0oooo04`0oooo001=0?ooo`03
0000003oool0oooo07`0oooo00@0^W8007:jjP3DV`00VmCo1`3oool00`000000oooo0?ooo`280?oo
o`030000003oool0oooo04/0oooo001<0?ooo`030000003oool0oooo07d0oooo00@0onZj0780LP1b
LP00VmCo1`3oool00`000000oooo0?ooo`280?ooo`030000003oool0oooo04/0oooo001<0?ooo`03
0000003oool0oooo07h0oooo00<0omBK0000002Ke?l01`3oool00`000000oooo0?ooo`290?ooo`03
0000003oool0oooo04X0oooo001;0?ooo`030000003oool0oooo08T0oooo00<000000?ooo`3oool0
R@3oool00`000000oooo0?ooo`1:0?ooo`00B`3oool00`000000oooo0?ooo`290?ooo`030000003o
ool0oooo08X0oooo00<000000?ooo`3oool0B@3oool004/0oooo00<000000?ooo`3oool0R@3oool0
0`000000oooo0?ooo`2:0?ooo`030000003oool0oooo04T0oooo001:0?ooo`030000003oool0oooo
08X0oooo00<000000?ooo`3oool0R`3oool00`000000oooo0?ooo`180?ooo`00BP3oool00`000000
oooo0?ooo`2:0?ooo`<00000R`3oool00`000000oooo0?ooo`180?ooo`00B@3oool00`000000oooo
0?ooo`2;0?ooo`030000003oool0oooo08/0oooo00<000000?ooo`3oool0B03oool004T0oooo00<0
00000?ooo`3oool0R`3oool00`000000oooo0?ooo`2<0?ooo`030000003oool0oooo04L0oooo0018
0?ooo`030000003oool0oooo08`0oooo00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`17
0?ooo`00B03oool00`000000oooo0?ooo`2<0?ooo`030000003oool0oooo08d0oooo00<000000?oo
o`3oool0AP3oool004P0oooo00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`2=0?ooo`03
0000003oool0oooo04H0oooo00170?ooo`030000003oool0oooo08d0oooo00<000000?ooo`3oool0
SP3oool00`000000oooo0?ooo`150?ooo`00A`3oool00`000000oooo0?ooo`2=0?ooo`030000003o
ool0oooo08h0oooo00<000000?ooo`3oool0A@3oool004H0oooo00<000000?ooo`3oool0SP3oool0
0`000000oooo0?ooo`2>0?ooo`030000003oool0oooo04D0oooo00160?ooo`030000003oool0oooo
08h0oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`140?ooo`00AP3oool00`000000
oooo0?ooo`2>0?ooo`<00000S`3oool00`000000oooo0?ooo`140?ooo`00A@3oool00`000000oooo
0?ooo`2?0?ooo`030000003oool0oooo0900oooo00<000000?ooo`3oool0@`3oool004D0oooo00<0
00000?ooo`3oool0S`3oool00`000000oooo0?ooo`2@0?ooo`030000003oool0oooo04<0oooo0014
0?ooo`030000003oool0oooo0900oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?ooo`12
0?ooo`00A03oool00`000000oooo0?ooo`2@0?ooo`030000003oool0oooo0940oooo00<000000?oo
o`3oool0@P3oool004@0oooo00<000000?ooo`3oool0T03oool00`000000oooo0?ooo`2A0?ooo`03
0000003oool0oooo0480oooo00130?ooo`030000003oool0oooo0940oooo00<000000?ooo`3oool0
TP3oool00`000000oooo0?ooo`110?ooo`00@`3oool00`000000oooo0?ooo`2A0?ooo`030000003o
ool0oooo0980oooo00<000000?ooo`3oool0@@3oool00480oooo00<000000?ooo`3oool0TP3oool0
0`000000oooo0?ooo`2B0?ooo`030000003oool0oooo0440oooo00120?ooo`030000003oool0oooo
0980oooo00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`100?ooo`00@P3oool00`000000
oooo0?ooo`2B0?ooo`<00000T`3oool00`000000oooo0?ooo`100?ooo`00@@3oool00`000000oooo
0?ooo`2C0?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool0@03oool00440oooo00<0
00000?ooo`3oool0T`3oool00`000000oooo0?ooo`2D0?ooo`030000003oool0oooo03l0oooo0010
0?ooo`030000003oool0oooo09@0oooo00<000000?ooo`3oool0U03oool00`000000oooo0?ooo`0o
0?ooo`00@03oool00`000000oooo0?ooo`2D0?ooo`030000003oool0oooo09D0oooo00<000000?oo
o`3oool0?P3oool00400oooo00<000000?ooo`3oool0U03oool00`000000oooo0?ooo`2E0?ooo`03
0000003oool0oooo03h0oooo000o0?ooo`030000003oool0oooo09D0oooo00<000000?ooo`3oool0
U@3oool00`000000oooo0?ooo`0n0?ooo`00?`3oool00`000000oooo0?ooo`2:0?ooo`050=BK0000
000000000000V`3Dool01P3oool00`000000oooo0?ooo`2F0?ooo`030000003oool0oooo03d0oooo
000n0?ooo`030000003oool0oooo08X0oooo00H0j[Yb002Ke03oool0oooo0?oDV`00Vm@60?ooo`03
0000003oool0oooo09H0oooo00<000000?ooo`3oool0?@3oool003h0oooo00<000000?ooo`3oool0
R@3oool00`3oom@0V`0009_Do`020?ooo`030?ooe02KL[X0oooo00D0oooo00<000000?ooo`3oool0
UP3oool00`000000oooo0?ooo`0m0?ooo`00?@3oool00`000000oooo0?ooo`2:0?ooo`070?oDV`00
LW80V`2K0=Coo`3oool0j[Yb002Ke0060?ooo`@00000UP3oool00`000000oooo0?ooo`0l0?ooo`00
?@3oool00`000000oooo0?ooo`2:0?ooo`030?oZ^P1bL[X0omBK0080000000<007:j0?ooo`3oool0
1@3oool00`000000oooo0?ooo`2G0?ooo`030000003oool0oooo03`0oooo000m0?ooo`030000003o
ool0oooo08X0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`2G0?ooo`030000003o
ool0oooo03`0oooo000l0?ooo`030000003oool0oooo08`0oooo00<0e9/007:jjP3oool02@3oool0
0`000000oooo0?ooo`2H0?ooo`030000003oool0oooo03/0oooo000l0?ooo`030000003oool0oooo
08`0oooo00<0oooD09/00000Vm@02@3oool00`000000oooo0?ooo`2H0?ooo`030000003oool0oooo
03/0oooo000k0?ooo`030000003oool0oooo08l0oooo00@0e9/000000000000007:j1P3oool00`00
0000oooo0?ooo`2H0?ooo`030000003oool0oooo03/0oooo000k0?ooo`030000003oool0oooo09T0
oooo00<000000?ooo`3oool0V@3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo
0?ooo`2I0?ooo`030000003oool0oooo09T0oooo00<000000?ooo`3oool0>P3oool003X0oooo00<0
00000?ooo`3oool0VP3oool00`000000oooo0?ooo`2J0?ooo`030000003oool0oooo03T0oooo000j
0?ooo`030000003oool0oooo09X0oooo00<000000?ooo`3oool0VP3oool00`000000oooo0?ooo`0i
0?ooo`00>@3oool00`000000oooo0?ooo`2K0?ooo`030000003oool0oooo09X0oooo00<000000?oo
o`3oool0>@3oool003T0oooo00<000000?ooo`3oool0V`3oool3000009/0oooo00<000000?ooo`3o
ool0>03oool003T0oooo00<000000?ooo`3oool0V`3oool00`000000oooo0?ooo`2K0?ooo`030000
003oool0oooo03P0oooo000h0?ooo`030000003oool0oooo09`0oooo00<000000?ooo`3oool0V`3o
ool00`000000oooo0?ooo`0h0?ooo`00>03oool00`000000oooo0?ooo`2L0?ooo`030000003oool0
oooo09`0oooo00<000000?ooo`3oool0=`3oool003L0oooo00<000000?ooo`3oool0W@3oool00`00
0000oooo0?ooo`2L0?ooo`030000003oool0oooo03L0oooo000g0?ooo`030000003oool0oooo09d0
oooo00<000000?ooo`3oool0W03oool00`000000oooo0?ooo`0g0?ooo`00=`3oool00`000000oooo
0?ooo`2M0?ooo`030000003oool0oooo09d0oooo00<000000?ooo`3oool0=P3oool003H0oooo00<0
00000?ooo`3oool0WP3oool00`000000oooo0?ooo`2M0?ooo`030000003oool0oooo03H0oooo000f
0?ooo`030000003oool0oooo09h0oooo00<000000?ooo`3oool0W@3oool00`000000oooo0?ooo`0f
0?ooo`00=@3oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo09h0oooo00<000000?oo
o`3oool0=@3oool003D0oooo00<000000?ooo`3oool0W`3oool3000009h0oooo00<000000?ooo`3o
ool0=@3oool003D0oooo00<000000?ooo`3oool0W`3oool00`000000oooo0?ooo`2O0?ooo`030000
003oool0oooo03@0oooo000d0?ooo`030000003oool0oooo0:00oooo00<000000?ooo`3oool0W`3o
ool00`000000oooo0?ooo`0d0?ooo`00=03oool00`000000oooo0?ooo`2P0?ooo`030000003oool0
oooo09l0oooo00<000000?ooo`3oool0=03oool003@0oooo00<000000?ooo`3oool0X03oool00`00
0000oooo0?ooo`2P0?ooo`030000003oool0oooo03<0oooo000c0?ooo`030000003oool0oooo0:40
oooo00<000000?ooo`3oool0X03oool00`000000oooo0?ooo`0c0?ooo`00<`3oool00`000000oooo
0?ooo`2Q0?ooo`030000003oool0oooo0:00oooo00<000000?ooo`3oool0<`3oool003<0oooo00<0
00000?ooo`3oool0X@3oool00`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo0380oooo000b
0?ooo`030000003oool0oooo0:80oooo00<000000?ooo`3oool0X@3oool00`000000oooo0?ooo`0b
0?ooo`00<P3oool00`000000oooo0?ooo`2R0?ooo`030000003oool0oooo0:40oooo00<000000?oo
o`3oool0<P3oool00380oooo00<000000?ooo`3oool0XP3oool300000:80oooo00<000000?ooo`3o
ool0<@3oool00340oooo00<000000?ooo`3oool0X`3oool00`000000oooo0?ooo`2R0?ooo`030000
003oool0oooo0340oooo000a0?ooo`030000003oool0oooo0:<0oooo00<000000?ooo`3oool0XP3o
ool00`000000oooo0?ooo`0a0?ooo`00<@3oool00`000000oooo0?ooo`2S0?ooo`030000003oool0
oooo0:<0oooo00<000000?ooo`3oool0<03oool00300oooo00<000000?ooo`3oool0Y03oool00`00
0000oooo0?ooo`2S0?ooo`030000003oool0oooo0300oooo000`0?ooo`030000003oool0oooo0:@0
oooo00<000000?ooo`3oool0Y03oool00`000000oooo0?ooo`0_0?ooo`00<03oool00`000000oooo
0?ooo`2H0?ooo`050=BK00000000000000000000Vm@01`3oool00`000000oooo0?ooo`2T0?ooo`03
0000003oool0oooo02l0oooo000_0?ooo`030000003oool0oooo09P0oooo00<0omBK002Ke03oool0
0P3oool00`3DVg80^^[o0?ooo`050?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3oool0
;`3oool002l0oooo00<000000?ooo`3oool0V03oool00`3Z^W80L[[Z0?ooo`020?ooo`030=BK002K
e?l0oooo00D0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?ooo`0^0?ooo`00;`3oool0
0`000000oooo0?ooo`2H0?ooo`030?oDV`00L[X0oooo0080oooo00<0^W9b0;[Zo`3oool01@3oool0
0`000000oooo0?ooo`2U0?ooo`030000003oool0oooo02h0oooo000^0?ooo`030000003oool0oooo
09X0oooo00D0j[Yb000000000000000007:jjP070?ooo`@00000Y03oool00`000000oooo0?ooo`0^
0?ooo`00;P3oool00`000000oooo0?ooo`2I0?ooo`030?ooe02KL[X0oooo0080oooo00<0^W:K0=Co
o`3oool01@3oool00`000000oooo0?ooo`2V0?ooo`030000003oool0oooo02d0oooo000^0?ooo`03
0000003oool0oooo09T0oooo00<0omBK07:jjP3oool00P3oool00`3DV`00VmCo0?ooo`050?ooo`03
0000003oool0oooo0:H0oooo00<000000?ooo`3oool0;@3oool002d0oooo00<000000?ooo`3oool0
VP3oool01`3oj[X0LP2K0=Coo`3oool0onZj0780V`3Dool01P3oool00`000000oooo0?ooo`2V0?oo
o`030000003oool0oooo02d0oooo000]0?ooo`030000003oool0oooo09/0oooo00D0omBK00000000
0000001b0;[Zo`070?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool0;03oool002`0
oooo00<000000?ooo`3oool0Z03oool00`000000oooo0?ooo`2W0?ooo`030000003oool0oooo02`0
oooo000/0?ooo`030000003oool0oooo0:P0oooo00<000000?ooo`3oool0Z03oool00`000000oooo
0?ooo`0[0?ooo`00;03oool00`000000oooo0?ooo`2X0?ooo`030000003oool0oooo0:P0oooo00<0
00000?ooo`3oool0:`3oool002/0oooo00<000000?ooo`3oool0Z@3oool00`000000oooo0?ooo`2X
0?ooo`030000003oool0oooo02/0oooo000[0?ooo`030000003oool0oooo0:T0oooo00<000000?oo
o`3oool0Z@3oool00`000000oooo0?ooo`0Z0?ooo`00:`3oool00`000000oooo0?ooo`2Y0?ooo`<0
0000Z@3oool00`000000oooo0?ooo`0Z0?ooo`00:P3oool00`000000oooo0?ooo`2Z0?ooo`030000
003oool0oooo0:T0oooo00<000000?ooo`3oool0:P3oool002X0oooo00<000000?ooo`3oool0ZP3o
ool00`000000oooo0?ooo`2Z0?ooo`030000003oool0oooo02T0oooo000Z0?ooo`030000003oool0
oooo0:X0oooo00<000000?ooo`3oool0ZP3oool00`000000oooo0?ooo`0Y0?ooo`00:@3oool00`00
0000oooo0?ooo`2[0?ooo`030000003oool0oooo0:X0oooo00<000000?ooo`3oool0:@3oool002T0
oooo00<000000?ooo`3oool0Z`3oool00`000000oooo0?ooo`2[0?ooo`030000003oool0oooo02P0
oooo000Y0?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`3oool0Z`3oool00`000000oooo
0?ooo`0X0?ooo`00:03oool00`000000oooo0?ooo`2/0?ooo`030000003oool0oooo0:/0oooo00<0
00000?ooo`3oool0:03oool002P0oooo00<000000?ooo`3oool0[03oool00`000000oooo0?ooo`2/
0?ooo`030000003oool0oooo02L0oooo000X0?ooo`030000003oool0oooo0:`0oooo00<000000?oo
o`3oool0[03oool00`000000oooo0?ooo`0W0?ooo`009`3oool00`000000oooo0?ooo`2]0?ooo`<0
0000[@3oool00`000000oooo0?ooo`0V0?ooo`009`3oool00`000000oooo0?ooo`2]0?ooo`030000
003oool0oooo0:d0oooo00<000000?ooo`3oool09P3oool002L0oooo00<000000?ooo`3oool0[@3o
ool00`000000oooo0?ooo`2]0?ooo`030000003oool0oooo02H0oooo000V0?ooo`030000003oool0
oooo0:h0oooo00<000000?ooo`3oool0[P3oool00`000000oooo0?ooo`0U0?ooo`009P3oool00`00
0000oooo0?ooo`2^0?ooo`030000003oool0oooo0:h0oooo00<000000?ooo`3oool09@3oool002H0
oooo00<000000?ooo`3oool0[P3oool00`000000oooo0?ooo`2^0?ooo`030000003oool0oooo02D0
oooo000U0?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0[`3oool00`000000oooo
0?ooo`0T0?ooo`009@3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0:l0oooo00<0
00000?ooo`3oool0903oool002D0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`2_
0?ooo`030000003oool0oooo02@0oooo000T0?ooo`030000003oool0oooo0;00oooo00<000000?oo
o`3oool0/03oool00`000000oooo0?ooo`0S0?ooo`00903oool00`000000oooo0?ooo`2`0?ooo`<0
0000/03oool00`000000oooo0?ooo`0S0?ooo`00903oool00`000000oooo0?ooo`2`0?ooo`030000
003oool0oooo0;40oooo00<000000?ooo`3oool08P3oool002<0oooo00<000000?ooo`3oool0/@3o
ool00`000000oooo0?ooo`2a0?ooo`030000003oool0oooo0280oooo000S0?ooo`030000003oool0
oooo0;40oooo00<000000?ooo`3oool0/@3oool00`000000oooo0?ooo`0R0?ooo`008`3oool00`00
0000oooo0?ooo`2a0?ooo`030000003oool0oooo0;80oooo00<000000?ooo`3oool08@3oool00280
oooo00<000000?ooo`3oool0/P3oool00`000000oooo0?ooo`2b0?ooo`030000003oool0oooo0240
oooo000R0?ooo`030000003oool0oooo09`0oooo00<0omBK0000000000000`0000001@00Vm@0oooo
0?ooo`3oool0omBK00<0000000<0VmCo0?ooo`3oool01@3oool00`000000oooo0?ooo`2b0?ooo`03
0000003oool0oooo0240oooo000R0?ooo`030000003oool0oooo09l0oooo00<0^W9b0;[Zo`3oool0
103oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`H0oooo00<000000?ooo`3oool0/`3oool00`00
0000oooo0?ooo`0P0?ooo`008@3oool00`000000oooo0?ooo`2P0?ooo`030;YbLP2jj_l0oooo00<0
oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?ooo`050?ooo`030000003oool0oooo0;<0
oooo00<000000?ooo`3oool0803oool00240oooo00<000000?ooo`3oool0X03oool00`2jLW80^^[o
0?ooo`030?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool01@3oool00`000000oooo
0?ooo`2c0?ooo`030000003oool0oooo0200oooo000Q0?ooo`030000003oool0oooo0:00oooo00<0
^W9b0;[Zo`3oool00`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00D0oooo1000
002c0?ooo`030000003oool0oooo01l0oooo000P0?ooo`030000003oool0oooo0:40oooo00<0^W9b
0;[Zo`3oool00`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00D0oooo00<00000
0?ooo`3oool0]03oool00`000000oooo0?ooo`0O0?ooo`00803oool00`000000oooo0?ooo`2Q0?oo
o`030;YbLP2jj_l0oooo00<0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`050?oo
o`030000003oool0oooo0;@0oooo00<000000?ooo`3oool07`3oool00200oooo00<000000?ooo`3o
ool0WP3oool01@3Z^W800000001b^P2jLW80^^[o00D0oooo00H0^W8009_Do`3oool0onZj0780V`3D
ool60?ooo`030000003oool0oooo0;@0oooo00<000000?ooo`3oool07`3oool00200oooo00<00000
0?ooo`3oool0X03oool00`3Z^W80001b0;[Zo`050?ooo`050?ooe02K000000000000LP2jj_l01`3o
ool00`000000oooo0?ooo`2e0?ooo`030000003oool0oooo01h0oooo000O0?ooo`030000003oool0
oooo0;D0oooo00<000000?ooo`3oool0]@3oool00`000000oooo0?ooo`0N0?ooo`007`3oool00`00
0000oooo0?ooo`2e0?ooo`030000003oool0oooo0;D0oooo00<000000?ooo`3oool07P3oool001l0
oooo00<000000?ooo`3oool0]@3oool00`000000oooo0?ooo`2f0?ooo`030000003oool0oooo01d0
oooo000N0?ooo`030000003oool0oooo0;H0oooo00<000000?ooo`3oool0]P3oool00`000000oooo
0?ooo`0M0?ooo`007P3oool00`000000oooo0?ooo`2f0?ooo`030000003oool0oooo0;H0oooo00<0
00000?ooo`3oool07@3oool001h0oooo00<000000?ooo`3oool0]P3oool300000;L0oooo00<00000
0?ooo`3oool0703oool001d0oooo00<000000?ooo`3oool0]`3oool00`000000oooo0?ooo`2g0?oo
o`030000003oool0oooo01`0oooo000M0?ooo`030000003oool0oooo0;L0oooo00<000000?ooo`3o
ool0]`3oool00`000000oooo0?ooo`0L0?ooo`007@3oool00`000000oooo0?ooo`2g0?ooo`030000
003oool0oooo0;P0oooo00<000000?ooo`3oool06`3oool001`0oooo00<000000?ooo`3oool0^03o
ool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo01/0oooo000L0?ooo`030000003oool0
oooo0;P0oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0K0?ooo`00703oool00`00
0000oooo0?ooo`2h0?ooo`030000003oool0oooo0;T0oooo00<000000?ooo`3oool06P3oool001/0
oooo00<000000?ooo`3oool0^@3oool00`000000oooo0?ooo`2i0?ooo`030000003oool0oooo01X0
oooo000K0?ooo`030000003oool0oooo0;T0oooo00<000000?ooo`3oool0^@3oool00`000000oooo
0?ooo`0J0?ooo`006`3oool00`000000oooo0?ooo`2i0?ooo`030000003oool0oooo0;T0oooo00<0
00000?ooo`3oool06P3oool001X0oooo00<000000?ooo`3oool0^P3oool300000;X0oooo00<00000
0?ooo`3oool06@3oool001X0oooo00<000000?ooo`3oool0^P3oool00`000000oooo0?ooo`2j0?oo
o`030000003oool0oooo01T0oooo000J0?ooo`030000003oool0oooo0;X0oooo00<000000?ooo`3o
ool0^P3oool00`000000oooo0?ooo`0I0?ooo`006@3oool00`000000oooo0?ooo`2k0?ooo`030000
003oool0oooo0;/0oooo00<000000?ooo`3oool0603oool001T0oooo00<000000?ooo`3oool0^`3o
ool00`000000oooo0?ooo`2k0?ooo`030000003oool0oooo01P0oooo000I0?ooo`030000003oool0
oooo0;/0oooo00<000000?ooo`3oool0^`3oool00`000000oooo0?ooo`0H0?ooo`00603oool00`00
0000oooo0?ooo`2l0?ooo`030000003oool0oooo0;`0oooo00<000000?ooo`3oool05`3oool001P0
oooo00<000000?ooo`3oool0_03oool00`000000oooo0?ooo`2l0?ooo`030000003oool0oooo01L0
oooo000H0?ooo`030000003oool0oooo0;`0oooo00<000000?ooo`3oool0_03oool00`000000oooo
0?ooo`0G0?ooo`00603oool00`000000oooo0?ooo`2l0?ooo`030000003oool0oooo0;d0oooo00<0
00000?ooo`3oool05P3oool001L0oooo00<000000?ooo`3oool0_@3oool300000;d0oooo00<00000
0?ooo`3oool05P3oool001L0oooo00<000000?ooo`3oool0_@3oool00`000000oooo0?ooo`2m0?oo
o`030000003oool0oooo01H0oooo000G0?ooo`030000003oool0oooo0;d0oooo00<000000?ooo`3o
ool0_P3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`2n0?ooo`030000
003oool0oooo0;h0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0_P3o
ool00`000000oooo0?ooo`2n0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0
oooo0;h0oooo00<000000?ooo`3oool0_P3oool00`000000oooo0?ooo`0E0?ooo`005@3oool00`00
0000oooo0?ooo`2Y0?ooo`030?oDV`000000000000<0000000@009_D0?ooo`3oom@0V`001@000000
0`2Ke?l0oooo0?ooo`040?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool0503oool0
01D0oooo00<000000?ooo`3oool0[03oool00`2jLW80^^[o0?ooo`030?ooo`030=BK000009/0e?oo
0080oooo00<0j[ZK0;[Zo`3oool01@3oool00`000000oooo0?ooo`2o0?ooo`030000003oool0oooo
01@0oooo000E0?ooo`030000003oool0oooo0:`0oooo00<0^W9b0;[Zo`3oool0103oool00`3oe9/0
001b0;[Zo`090?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool0503oool001@0oooo
00<000000?ooo`3oool0[@3oool00`2jLW80^^[o0?ooo`050?ooo`030?oZ^P1b0000L[[Z00P0oooo
00<000000?ooo`3oool0`03oool00`000000oooo0?ooo`0C0?ooo`00503oool00`000000oooo0?oo
o`2]0?ooo`030;YbLP2jj_l0oooo00L0oooo00<0^W8007:jjP3oool01P3oool400000;l0oooo00<0
00000?ooo`3oool04`3oool00<@0oooo00<0^W9b0;[Zo`3oool0203oool00`2jLY/0e?oo0?ooo`05
0?ooo`030000003oool0oooo0=H0oooo00340?ooo`030;YbLP2jj_l0oooo00<0oooo00<0j[Yb09_D
o`3oool00P3oool00`3DV`00VmCo0?ooo`050?ooo`030000003oool0oooo0=H0oooo00310?ooo`05
0>ZjLP00000007:j0;YbLP2jj_l0103oool01`3oe9/0002K0=Coo`3oool0omBK0000LP2jj_l01P3o
ool00`000000oooo0?ooo`3F0?ooo`00``3oool00`3Z^W80001b0;[Zo`050?ooo`050?oDV`000000
00000000LP2jj_l01`3oool00`000000oooo0?ooo`3F0?ooo`00e`3oool00`000000oooo0?ooo`3F
0?ooo`00e`3oool00`000000oooo0?ooo`3F0?ooo`00\
\>"],
  ImageRangeCache->{{{91.1875, 378.188}, {240.938, 64}} -> {-7.25049, 
  3.86921, 0.0308942, 0.0749821}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 6"]], "Exercise"],

Cell[TextData[StyleBox[
"Representa las animaciones gr\[AAcute]ficas que se indican a continuaci\
\[OAcute]n y explica las evoluciones de las correspondientes \
gr\[AAcute]ficas. \n\ta) sen(n*x), para n=1,2, ..., 15.\n\tb) n*sen(x),  para \
n=1,2, ..., 15.\n\tc) sen(x) + n,  para n=1,2, ..., 15.\n\td) sen(x + n),  \
para n=1,2, ..., 15.\t\t"]], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 7"]], "Exercise"],

Cell["\<\
Realiza una animaci\[OAcute]n gr\[AAcute]fica usando \"ParametricPlot[ ]\" \
para representar la curva ((Abs[Sin[t]Cos[4t]]+.2)(1-s)+s){Cos[t],Sin[t]} \
donde t\[Element][0,2Pi] para valores del par\[AAcute]metro s de 0 hasta 1 \
con incrementos de 0.1. Usa opciones apropiadas AspectRatio, PlotRange, \
PlotStyle.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 8"]], "Exercise"],

Cell[TextData[StyleBox[
"Utilizando primitivas gr\[AAcute]ficas representa una elipse de semiejes 2 y \
4. Inscribe en ella un rect\[AAcute]ngulo y dentro del rect\[AAcute]ngulo una \
circunferencia. Dibuja la elipse en azul, el rect\[AAcute]ngulo en verde y la \
circunferencia en rojo.",
  FontFamily->"Times New Roman"]], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 9"]], "Exercise"],

Cell[TextData[StyleBox[
"Utilizando primitivas gr\[AAcute]ficas dibuja un tri\[AAcute]ngulo y colorea \
los v\[EAcute]rtices en rojo, verde y azul. Une con segmentos los puntos \
medios de cada lado del tri\[AAcute]ngulo para dibujar otro \
tri\[AAcute]ngulo.",
  FontFamily->"Times New Roman"]], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 10"]], "Exercise"],

Cell[TextData[{
  StyleBox["Usando primitivas gr\[AAcute]ficas apropiadas representa un \
\"smiley\" ",
    FontFamily->"Times New Roman"],
  StyleBox["\[HappySmiley].",
    FontFamily->"Times New Roman",
    FontSize->24]
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 11"]], "Exercise"],

Cell[TextData[{
  StyleBox["Representa la curva ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(Cos[x]\^2\),
            "TraditionalForm"], "-", " ", \(x\ Sin[x]\)}], 
        TraditionalForm]]],
  StyleBox[
  " en el intervalo [-Pi,Pi] y sobre ella representa 8 puntos cuyo tama\
\[NTilde]o y color debes elegir t\[UAcute].",
    FontFamily->"Times New Roman"]
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
WindowSize->{978, 611},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Representaciones gr\[AAcute]ficas en el plano."], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Representaciones gr\[AAcute]ficas en el plano."], 
        "Header"]}},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 62, 0, 69, "Title"],
Cell[1774, 51, 203, 3, 72, "Author"],

Cell[CellGroupData[{
Cell[2002, 58, 39, 0, 69, "Section"],
Cell[2044, 60, 600, 12, 198, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2681, 77, 37, 0, 69, "Section"],
Cell[2721, 79, 749, 16, 98, "Text"],
Cell[3473, 97, 130, 2, 60, "Input"],
Cell[3606, 101, 439, 10, 60, "Text"],
Cell[4048, 113, 141, 3, 62, "Input"],
Cell[4192, 118, 701, 14, 120, "Text"],
Cell[4896, 134, 46, 1, 60, "Input"],
Cell[4945, 137, 188, 4, 55, "Text"],
Cell[5136, 143, 103, 1, 33, "Text"],
Cell[5242, 146, 882, 17, 142, "Text"],
Cell[6127, 165, 28, 0, 42, "Example"],
Cell[6158, 167, 660, 14, 98, "Text"],
Cell[6821, 183, 67, 1, 60, "Input"],
Cell[6891, 186, 174, 5, 33, "Text"],
Cell[7068, 193, 231, 6, 55, "Text"],
Cell[7302, 201, 213, 3, 81, "Input"],
Cell[7518, 206, 450, 9, 77, "Text"],
Cell[7971, 217, 184, 3, 33, "Text"],
Cell[8158, 222, 209, 3, 81, "Input"],
Cell[8370, 227, 196, 3, 55, "Text"],
Cell[8569, 232, 77, 1, 60, "Input"],
Cell[8649, 235, 133, 3, 33, "Text"],
Cell[8785, 240, 133, 2, 60, "Input"],
Cell[8921, 244, 29, 0, 42, "Example"],
Cell[8953, 246, 385, 8, 55, "Text"],
Cell[9341, 256, 157, 3, 81, "Input"],
Cell[9501, 261, 185, 4, 33, "Text"],
Cell[9689, 267, 30, 0, 42, "Example"],
Cell[9722, 269, 973, 21, 133, "Text"],
Cell[10698, 292, 107, 2, 66, "Input"],
Cell[10808, 296, 1141, 25, 163, "Text"],
Cell[11952, 323, 1165, 34, 66, "Input"],
Cell[13120, 359, 28, 0, 42, "Example"],
Cell[13151, 361, 205, 4, 55, "Text"],
Cell[13359, 367, 128, 3, 33, "Text"],
Cell[13490, 372, 295, 5, 55, "Text"],
Cell[13788, 379, 75, 1, 33, "Text"],
Cell[13866, 382, 387, 7, 77, "Text"],
Cell[14256, 391, 586, 8, 130, "Text"],
Cell[14845, 401, 159, 4, 60, "Input"],
Cell[15007, 407, 146, 3, 33, "Text"],
Cell[15156, 412, 175, 4, 81, "Input"],
Cell[15334, 418, 213, 5, 81, "Input"],

Cell[CellGroupData[{
Cell[15572, 427, 61, 0, 56, "Subsection"],
Cell[15636, 429, 220, 3, 55, "Text"],
Cell[15859, 434, 481, 9, 146, "Input"],
Cell[16343, 445, 282, 4, 55, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16674, 455, 37, 0, 68, "Section"],
Cell[16714, 457, 529, 12, 77, "Text"],
Cell[17246, 471, 522, 12, 146, "Input"],
Cell[17771, 485, 722, 17, 98, "Text"],
Cell[18496, 504, 974, 20, 255, "Input"],
Cell[19473, 526, 142, 5, 33, "Text"],
Cell[19618, 533, 50, 1, 60, "Input"],
Cell[19671, 536, 202, 6, 33, "Text"],
Cell[19876, 544, 482, 9, 125, "Input"],
Cell[20361, 555, 251, 7, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20649, 567, 47, 0, 68, "Section"],
Cell[20699, 569, 2025, 48, 260, "Text"],
Cell[22727, 619, 305, 5, 146, "Input"],
Cell[23035, 626, 107, 2, 33, "Text"],
Cell[23145, 630, 158, 2, 102, "Input"],
Cell[23306, 634, 235, 7, 33, "Text"],
Cell[23544, 643, 55, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23636, 649, 47, 0, 68, "Section"],
Cell[23686, 651, 1198, 28, 120, "Text"],
Cell[24887, 681, 76, 1, 33, "Text"],
Cell[24966, 684, 116, 1, 33, "Text"],
Cell[25085, 687, 56, 1, 60, "Input"],
Cell[25144, 690, 53, 0, 33, "Text"],
Cell[25200, 692, 197, 4, 81, "Input"],
Cell[25400, 698, 226, 5, 102, "Input"],
Cell[25629, 705, 141, 2, 33, "Text"],
Cell[25773, 709, 269, 6, 55, "Text"],
Cell[26045, 717, 123, 2, 60, "Input"],
Cell[26171, 721, 276, 6, 55, "Text"],
Cell[26450, 729, 136, 2, 81, "Input"],
Cell[26589, 733, 773, 22, 81, "Text"],
Cell[27365, 757, 151, 3, 78, "Input"],
Cell[27519, 762, 293, 6, 55, "Text"],
Cell[27815, 770, 183, 3, 125, "Input"],
Cell[28001, 775, 289, 6, 55, "Text"],
Cell[28293, 783, 127, 2, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28457, 790, 46, 0, 68, "Section"],
Cell[28506, 792, 429, 12, 57, "Text"],
Cell[28938, 806, 122, 2, 33, "Text"],
Cell[29063, 810, 167, 5, 33, "Text"],
Cell[29233, 817, 148, 3, 33, "Text"],
Cell[29384, 822, 141, 3, 33, "Text"],
Cell[29528, 827, 127, 2, 33, "Text"],
Cell[29658, 831, 124, 2, 33, "Text"],
Cell[29785, 835, 108, 2, 60, "Input"],
Cell[29896, 839, 1399, 28, 185, "Text"],
Cell[31298, 869, 88, 1, 60, "Input"],
Cell[31389, 872, 80, 1, 60, "Input"],
Cell[31472, 875, 218, 3, 55, "Text"],
Cell[31693, 880, 86, 1, 60, "Input"],
Cell[31782, 883, 92, 1, 33, "Text"],
Cell[31877, 886, 124, 3, 60, "Input"],
Cell[32004, 891, 185, 3, 33, "Text"],
Cell[32192, 896, 133, 3, 60, "Input"],
Cell[32328, 901, 145, 3, 81, "Input"],
Cell[32476, 906, 150, 3, 81, "Input"],

Cell[CellGroupData[{
Cell[32651, 913, 113, 2, 56, "Subsection"],
Cell[32767, 917, 273, 7, 55, "Text"],
Cell[33043, 926, 178, 4, 81, "Input"],
Cell[33224, 932, 649, 15, 77, "Text"],
Cell[33876, 949, 358, 5, 55, "Text"],
Cell[34237, 956, 209, 5, 81, "Input"],
Cell[34449, 963, 309, 5, 55, "Text"],
Cell[34761, 970, 411, 7, 125, "Input"],
Cell[35175, 979, 67, 0, 33, "Text"],
Cell[35245, 981, 164, 4, 60, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35458, 991, 47, 0, 68, "Section"],
Cell[35508, 993, 622, 10, 98, "Text"],
Cell[36133, 1005, 552, 10, 146, "Input"],
Cell[36688, 1017, 560, 10, 146, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37285, 1032, 26, 0, 68, "Section"],
Cell[37314, 1034, 574, 16, 77, "Text"],
Cell[37891, 1052, 97, 2, 60, "Input"],
Cell[37991, 1056, 717, 12, 120, "Text"],
Cell[38711, 1070, 134, 2, 60, "Input"],
Cell[38848, 1074, 559, 9, 98, "Text"],
Cell[39410, 1085, 102, 2, 60, "Input"],
Cell[39515, 1089, 110, 2, 81, "Input"],
Cell[39628, 1093, 40, 0, 33, "Text"],
Cell[39671, 1095, 65, 1, 60, "Input"],
Cell[39739, 1098, 108, 3, 33, "Text"],
Cell[39850, 1103, 57, 1, 60, "Input"],
Cell[39910, 1106, 189, 4, 55, "Text"],
Cell[40102, 1112, 202, 4, 102, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40341, 1121, 34, 0, 66, "ExerciseMain"],

Cell[CellGroupData[{
Cell[40400, 1125, 51, 0, 47, "Exercise"],
Cell[40454, 1127, 485, 7, 98, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40976, 1139, 51, 0, 47, "Exercise"],
Cell[41030, 1141, 278, 4, 55, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41345, 1150, 51, 0, 47, "Exercise"],
Cell[41399, 1152, 411, 10, 55, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41847, 1167, 51, 0, 47, "Exercise"],
Cell[41901, 1169, 295, 4, 55, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[42233, 1178, 51, 0, 47, "Exercise"],
Cell[42287, 1180, 127, 2, 65, "Text"],

Cell[CellGroupData[{
Cell[42439, 1186, 84742, 1424, 232, 6708, 456, "GraphicsData", 
"PostScript", "Graphics"],
Cell[127184, 2612, 35035, 693, 232, 4417, 311, "GraphicsData", 
"PostScript", "Graphics"],
Cell[162222, 3307, 40790, 805, 232, 5086, 360, "GraphicsData", 
"PostScript", "Graphics"],
Cell[203015, 4114, 34997, 663, 232, 3921, 275, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[238061, 4783, 51, 0, 47, "Exercise"],
Cell[238115, 4785, 362, 5, 168, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[238514, 4795, 51, 0, 47, "Exercise"],
Cell[238568, 4797, 346, 6, 60, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[238951, 4808, 51, 0, 48, "Exercise"],
Cell[239005, 4810, 340, 5, 60, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[239382, 4820, 51, 0, 48, "Exercise"],
Cell[239436, 4822, 312, 5, 36, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[239785, 4832, 52, 0, 48, "Exercise"],
Cell[239840, 4834, 242, 7, 51, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[240119, 4846, 52, 0, 48, "Exercise"],
Cell[240174, 4848, 441, 13, 36, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

